/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.minestom;

import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.network.NetworkClient;
import eu.cloudnetservice.driver.network.rpc.factory.RPCFactory;
import eu.cloudnetservice.driver.provider.CloudServiceProvider;
import eu.cloudnetservice.driver.provider.ServiceTaskProvider;
import eu.cloudnetservice.driver.registry.ServiceRegistry;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import eu.cloudnetservice.ext.platforminject.api.stereotype.ProvidesFor;
import eu.cloudnetservice.modules.bridge.BridgeManagement;
import eu.cloudnetservice.modules.bridge.BridgeServiceHelper;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.minestom.MinestomDirectPlayerExecutor;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerServerInfo;
import eu.cloudnetservice.modules.bridge.player.PlayerManager;
import eu.cloudnetservice.modules.bridge.player.ServicePlayer;
import eu.cloudnetservice.modules.bridge.player.executor.PlayerExecutor;
import eu.cloudnetservice.modules.bridge.util.BridgeHostAndPortUtil;
import eu.cloudnetservice.wrapper.configuration.WrapperConfiguration;
import eu.cloudnetservice.wrapper.event.ServiceInfoPropertiesConfigureEvent;
import eu.cloudnetservice.wrapper.holder.ServiceInfoHolder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import lombok.NonNull;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minestom.server.command.CommandManager;
import net.minestom.server.entity.Player;
import net.minestom.server.event.Event;
import net.minestom.server.event.GlobalEventHandler;
import net.minestom.server.event.server.ServerListPingEvent;
import net.minestom.server.network.ConnectionManager;
import net.minestom.server.permission.PermissionHandler;
import net.minestom.server.ping.ServerListPingType;
import org.jetbrains.annotations.Nullable;

@Singleton
@ProvidesFor(platform="minestom", types={PlatformBridgeManagement.class, BridgeManagement.class})
public final class MinestomBridgeManagement
extends PlatformBridgeManagement<Player, NetworkPlayerServerInfo> {
    private static final BiFunction<Player, String, Boolean> PERM_FUNCTION = PermissionHandler::hasPermission;
    private final CommandManager commandManager;
    private final ConnectionManager connectionManager;
    private final PlayerExecutor directGlobalExecutor;

    @Inject
    public MinestomBridgeManagement(@NonNull RPCFactory rpcFactory, @NonNull EventManager eventManager, @NonNull NetworkClient networkClient, @NonNull CommandManager commandManager, @NonNull GlobalEventHandler eventHandler, @NonNull ServiceTaskProvider taskProvider, @NonNull BridgeServiceHelper serviceHelper, @NonNull ConnectionManager connectionManager, @NonNull ServiceInfoHolder serviceInfoHolder, @NonNull CloudServiceProvider serviceProvider, @NonNull WrapperConfiguration wrapperConfiguration) {
        super(rpcFactory, eventManager, networkClient, taskProvider, serviceHelper, serviceInfoHolder, serviceProvider, wrapperConfiguration);
        if (rpcFactory == null) {
            throw new NullPointerException("rpcFactory is marked non-null but is null");
        }
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        if (commandManager == null) {
            throw new NullPointerException("commandManager is marked non-null but is null");
        }
        if (eventHandler == null) {
            throw new NullPointerException("eventHandler is marked non-null but is null");
        }
        if (taskProvider == null) {
            throw new NullPointerException("taskProvider is marked non-null but is null");
        }
        if (serviceHelper == null) {
            throw new NullPointerException("serviceHelper is marked non-null but is null");
        }
        if (connectionManager == null) {
            throw new NullPointerException("connectionManager is marked non-null but is null");
        }
        if (serviceInfoHolder == null) {
            throw new NullPointerException("serviceInfoHolder is marked non-null but is null");
        }
        if (serviceProvider == null) {
            throw new NullPointerException("serviceProvider is marked non-null but is null");
        }
        if (wrapperConfiguration == null) {
            throw new NullPointerException("wrapperConfiguration is marked non-null but is null");
        }
        this.commandManager = commandManager;
        this.connectionManager = connectionManager;
        this.directGlobalExecutor = new MinestomDirectPlayerExecutor(commandManager, PlayerExecutor.GLOBAL_UNIQUE_ID, () -> ((ConnectionManager)connectionManager).getOnlinePlayers());
        ServerListPingEvent pingEvent = new ServerListPingEvent(ServerListPingType.MODERN_FULL_RGB);
        eventHandler.call((Event)pingEvent);
        serviceHelper.motd().set(LegacyComponentSerializer.legacySection().serialize(pingEvent.getResponseData().getDescription()));
        serviceHelper.maxPlayers().set(pingEvent.getResponseData().getMaxPlayer());
    }

    @Override
    public void registerServices(@NonNull ServiceRegistry registry) {
        if (registry == null) {
            throw new NullPointerException("registry is marked non-null but is null");
        }
        registry.registerProvider(PlayerManager.class, "PlayerManager", this.playerManager);
        registry.registerProvider(PlatformBridgeManagement.class, "MinestomBridgeManagement", this);
    }

    @Override
    @NonNull
    public ServicePlayer wrapPlayer(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return new ServicePlayer(player.getUuid(), player.getUsername());
    }

    @Override
    @NonNull
    public NetworkPlayerServerInfo createPlayerInformation(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return new NetworkPlayerServerInfo(player.getUuid(), player.getUsername(), null, BridgeHostAndPortUtil.fromSocketAddress(player.getPlayerConnection().getRemoteAddress()), this.ownNetworkServiceInfo);
    }

    @Override
    @NonNull
    public BiFunction<Player, String, Boolean> permissionFunction() {
        return PERM_FUNCTION;
    }

    @Override
    public boolean isOnAnyFallbackInstance(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.isOnAnyFallbackInstance(this.ownNetworkServiceInfo.serverName(), null, arg_0 -> ((Player)player).hasPermission(arg_0));
    }

    @Override
    @NonNull
    public Optional<ServiceInfoSnapshot> fallback(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.fallback(player, this.ownNetworkServiceInfo.serverName());
    }

    @Override
    @NonNull
    public Optional<ServiceInfoSnapshot> fallback(@NonNull Player player, @Nullable String currServer) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.fallback(player.getUuid(), currServer, null, arg_0 -> ((Player)player).hasPermission(arg_0));
    }

    @Override
    public void handleFallbackConnectionSuccess(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.handleFallbackConnectionSuccess(player.getUuid());
    }

    @Override
    public void removeFallbackProfile(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.removeFallbackProfile(player.getUuid());
    }

    @Override
    @NonNull
    public PlayerExecutor directPlayerExecutor(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return uniqueId.equals(PlayerExecutor.GLOBAL_UNIQUE_ID) ? this.directGlobalExecutor : new MinestomDirectPlayerExecutor(this.commandManager, uniqueId, () -> Collections.singleton(this.connectionManager.getOnlinePlayerByUuid(uniqueId)));
    }

    @Override
    public void appendServiceInformation(@NonNull ServiceInfoPropertiesConfigureEvent configureEvent) {
        if (configureEvent == null) {
            throw new NullPointerException("configureEvent is marked non-null but is null");
        }
        super.appendServiceInformation(configureEvent);
        Collection onlinePlayers = this.connectionManager.getOnlinePlayers();
        configureEvent.propertyHolder().append("Online-Count", onlinePlayers.size());
        configureEvent.propertyHolder().append("Version", "1.21");
        configureEvent.propertyHolder().append("Players", onlinePlayers.stream().map(this::createPlayerInformation).toList());
    }
}

