/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.minestom;

import eu.cloudnetservice.driver.registry.ServiceRegistry;
import eu.cloudnetservice.driver.util.ModuleHelper;
import eu.cloudnetservice.ext.platforminject.api.PlatformEntrypoint;
import eu.cloudnetservice.ext.platforminject.api.stereotype.ExternalDependency;
import eu.cloudnetservice.ext.platforminject.api.stereotype.PlatformPlugin;
import eu.cloudnetservice.ext.platforminject.api.stereotype.Repository;
import eu.cloudnetservice.modules.bridge.platform.minestom.MinestomBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.minestom.MinestomPlayerManagementListener;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import lombok.NonNull;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.minestom.server.extras.MojangAuth;
import net.minestom.server.extras.bungee.BungeeCordProxy;
import net.minestom.server.extras.velocity.VelocityProxy;
import org.slf4j.Logger;

@Singleton
@PlatformPlugin(platform="minestom", name="CloudNet-Bridge", version="4.0.0-RC11", description="Bridges service software support between all supported versions for easy CloudNet plugin development", authors={"CloudNetService"}, externalDependencies={@ExternalDependency(groupId="com.google.guava", artifactId="guava", version="31.1-jre", repository=@Repository(id="Central", url="https://repo1.maven.org/maven2/"))})
public final class MinestomBridgeExtension
implements PlatformEntrypoint {
    private final Logger logger;
    private final ModuleHelper moduleHelper;
    private final ServiceRegistry serviceRegistry;
    private final MinestomBridgeManagement bridgeManagement;

    @Inject
    public MinestomBridgeExtension(@NonNull ComponentLogger logger, @NonNull ModuleHelper moduleHelper, @NonNull ServiceRegistry serviceRegistry, @NonNull MinestomBridgeManagement bridgeManagement, @NonNull MinestomPlayerManagementListener playerListener) {
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        if (moduleHelper == null) {
            throw new NullPointerException("moduleHelper is marked non-null but is null");
        }
        if (serviceRegistry == null) {
            throw new NullPointerException("serviceRegistry is marked non-null but is null");
        }
        if (bridgeManagement == null) {
            throw new NullPointerException("bridgeManagement is marked non-null but is null");
        }
        if (playerListener == null) {
            throw new NullPointerException("playerListener is marked non-null but is null");
        }
        this.logger = logger;
        this.moduleHelper = moduleHelper;
        this.serviceRegistry = serviceRegistry;
        this.bridgeManagement = bridgeManagement;
    }

    @Override
    public void onLoad() {
        this.bridgeManagement.registerServices(this.serviceRegistry);
        this.bridgeManagement.postInit();
        if (!VelocityProxy.isEnabled()) {
            BungeeCordProxy.enable();
        }
        if (!VelocityProxy.isEnabled() && MojangAuth.isEnabled()) {
            this.logger.warn("Be aware that using BungeeCord player info forwarding in combination with Mojang authentication will not work!");
        }
    }

    @Override
    public void onDisable() {
        this.moduleHelper.unregisterAll(this.getClass().getClassLoader());
    }
}

