/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.listener;

import eu.cloudnetservice.driver.event.EventListener;
import eu.cloudnetservice.driver.event.events.service.CloudServiceLifecycleChangeEvent;
import eu.cloudnetservice.driver.event.events.service.CloudServiceUpdateEvent;
import eu.cloudnetservice.driver.event.events.task.ServiceTaskAddEvent;
import eu.cloudnetservice.driver.event.events.task.ServiceTaskRemoveEvent;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import eu.cloudnetservice.wrapper.event.ServiceInfoPropertiesConfigureEvent;
import lombok.NonNull;

public final class PlatformInformationListener {
    private final PlatformBridgeManagement<?, ?> management;

    public PlatformInformationListener(@NonNull PlatformBridgeManagement<?, ?> management) {
        if (management == null) {
            throw new NullPointerException("management is marked non-null but is null");
        }
        this.management = management;
    }

    @EventListener
    public void handle(@NonNull ServiceInfoPropertiesConfigureEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.management.appendServiceInformation(event);
    }

    @EventListener
    public void handleLifecycleChange(@NonNull CloudServiceLifecycleChangeEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.management.handleServiceUpdate(event.serviceInfo());
    }

    @EventListener
    public void handleLifecycleChange(@NonNull CloudServiceUpdateEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.management.handleServiceUpdate(event.serviceInfo());
    }

    @EventListener
    public void handleServiceTaskAdd(@NonNull ServiceTaskAddEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.management.handleTaskUpdate(event.task().name(), event.task());
    }

    @EventListener
    public void handleServiceTaskRemove(@NonNull ServiceTaskRemoveEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.management.handleTaskUpdate(event.task().name(), null);
    }
}

