/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.listener;

import eu.cloudnetservice.driver.event.EventListener;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.event.events.channel.ChannelMessageReceiveEvent;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.modules.bridge.config.BridgeConfiguration;
import eu.cloudnetservice.modules.bridge.event.BridgeDeleteCloudOfflinePlayerEvent;
import eu.cloudnetservice.modules.bridge.event.BridgeProxyPlayerDisconnectEvent;
import eu.cloudnetservice.modules.bridge.event.BridgeProxyPlayerLoginEvent;
import eu.cloudnetservice.modules.bridge.event.BridgeProxyPlayerServerSwitchEvent;
import eu.cloudnetservice.modules.bridge.event.BridgeServerPlayerDisconnectEvent;
import eu.cloudnetservice.modules.bridge.event.BridgeServerPlayerLoginEvent;
import eu.cloudnetservice.modules.bridge.event.BridgeUpdateCloudOfflinePlayerEvent;
import eu.cloudnetservice.modules.bridge.event.BridgeUpdateCloudPlayerEvent;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import eu.cloudnetservice.modules.bridge.player.CloudOfflinePlayer;
import eu.cloudnetservice.modules.bridge.player.CloudPlayer;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerServerInfo;
import eu.cloudnetservice.modules.bridge.player.NetworkServiceInfo;
import eu.cloudnetservice.modules.bridge.player.executor.PlayerExecutor;
import eu.cloudnetservice.modules.bridge.player.executor.ServerSelectorType;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;

public final class PlatformChannelMessageListener {
    private final EventManager eventManager;
    private final PlatformBridgeManagement<?, ?> management;

    public PlatformChannelMessageListener(@NonNull EventManager eventManager, @NonNull PlatformBridgeManagement<?, ?> management) {
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (management == null) {
            throw new NullPointerException("management is marked non-null but is null");
        }
        this.eventManager = eventManager;
        this.management = management;
    }

    @EventListener
    public void handleConfigurationChannelMessage(@NonNull ChannelMessageReceiveEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (event.channel().equals("bridge_internal_com_channel") && event.message().equals("update_bridge_configuration")) {
            BridgeConfiguration configuration = event.content().readObject(BridgeConfiguration.class);
            this.management.configurationSilently(configuration);
        }
    }

    @EventListener
    public void handlePlayerChannelMessage(@NonNull ChannelMessageReceiveEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (event.channel().equals("bridge_internal_player_channel")) {
            switch (event.message()) {
                case "update_offline_cloud_player": {
                    CloudOfflinePlayer player = event.content().readObject(CloudOfflinePlayer.class);
                    this.eventManager.callEvent(new BridgeUpdateCloudOfflinePlayerEvent(player));
                    break;
                }
                case "update_online_cloud_player": {
                    CloudPlayer player = event.content().readObject(CloudPlayer.class);
                    this.eventManager.callEvent(new BridgeUpdateCloudPlayerEvent(player));
                    break;
                }
                case "delete_offline_cloud_player": {
                    CloudOfflinePlayer player = event.content().readObject(CloudOfflinePlayer.class);
                    this.eventManager.callEvent(new BridgeDeleteCloudOfflinePlayerEvent(player));
                    break;
                }
                case "process_cloud_player_login": {
                    CloudPlayer player = event.content().readObject(CloudPlayer.class);
                    this.eventManager.callEvent(new BridgeProxyPlayerLoginEvent(player));
                    break;
                }
                case "process_cloud_player_logout": {
                    CloudPlayer player = event.content().readObject(CloudPlayer.class);
                    this.eventManager.callEvent(new BridgeProxyPlayerDisconnectEvent(player));
                    break;
                }
                case "cloud_player_service_switch": {
                    CloudPlayer player = event.content().readObject(CloudPlayer.class);
                    NetworkServiceInfo previous = event.content().readObject(NetworkServiceInfo.class);
                    this.eventManager.callEvent(new BridgeProxyPlayerServerSwitchEvent(player, previous));
                    break;
                }
                case "cloud_player_server_login": {
                    CloudPlayer player = event.content().readObject(CloudPlayer.class);
                    NetworkPlayerServerInfo serviceInfo = event.content().readObject(NetworkPlayerServerInfo.class);
                    this.eventManager.callEvent(new BridgeServerPlayerLoginEvent(player, serviceInfo));
                    break;
                }
                case "cloud_player_server_disconnect": {
                    CloudPlayer player = event.content().readObject(CloudPlayer.class);
                    NetworkServiceInfo serviceInfo = event.content().readObject(NetworkServiceInfo.class);
                    this.eventManager.callEvent(new BridgeServerPlayerDisconnectEvent(player, serviceInfo));
                    break;
                }
            }
        }
    }

    @EventListener
    public void handlePlayerExecutorChannelMessage(@NonNull ChannelMessageReceiveEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (event.channel().equals("bridge_internal_player_executor_channel")) {
            PlayerExecutor executor = this.management.directPlayerExecutor(event.content().readUniqueId());
            switch (event.message()) {
                case "connect_to_service": {
                    executor.connect(event.content().readString());
                    break;
                }
                case "connect_to_selector": {
                    executor.connectSelecting(event.content().readObject(ServerSelectorType.class));
                    break;
                }
                case "connect_to_fallback": {
                    executor.connectToFallback();
                    break;
                }
                case "connect_to_group": {
                    executor.connectToGroup(event.content().readString(), event.content().readObject(ServerSelectorType.class));
                    break;
                }
                case "connect_to_task": {
                    executor.connectToTask(event.content().readString(), event.content().readObject(ServerSelectorType.class));
                    break;
                }
                case "kick_player": {
                    executor.kick(event.content().readObject(Component.class));
                    break;
                }
                case "send_title": {
                    executor.sendTitle(event.content().readObject(Title.class));
                    break;
                }
                case "send_chat_message": {
                    executor.sendChatMessage(event.content().readObject(Component.class), event.content().readNullable(DataBuf::readString));
                    break;
                }
                case "send_plugin_message": {
                    executor.sendPluginMessage(event.content().readString(), event.content().readByteArray());
                    break;
                }
                case "spoof_command_execution": {
                    executor.spoofCommandExecution(event.content().readString(), event.content().readBoolean());
                    break;
                }
            }
        }
    }
}

