/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.limboloohp;

import com.loohp.limbo.events.EventHandler;
import com.loohp.limbo.events.Listener;
import com.loohp.limbo.events.player.PlayerJoinEvent;
import com.loohp.limbo.events.player.PlayerQuitEvent;
import com.loohp.limbo.player.Player;
import com.loohp.limbo.plugins.LimboPlugin;
import com.loohp.limbo.scheduler.LimboScheduler;
import eu.cloudnetservice.driver.service.ServiceTask;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.helper.ServerPlatformHelper;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerServerInfo;
import eu.cloudnetservice.wrapper.holder.ServiceInfoHolder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Locale;
import lombok.NonNull;

@Singleton
public final class LimboLoohpPlayerManagementListener
implements Listener {
    private final LimboPlugin plugin;
    private final LimboScheduler scheduler;
    private final ServiceInfoHolder serviceInfoHolder;
    private final ServerPlatformHelper serverPlatformHelper;
    private final PlatformBridgeManagement<Player, NetworkPlayerServerInfo> management;

    @Inject
    public LimboLoohpPlayerManagementListener(@NonNull LimboPlugin plugin, @NonNull LimboScheduler scheduler, @NonNull ServiceInfoHolder serviceInfoHolder, @NonNull ServerPlatformHelper serverPlatformHelper, @NonNull PlatformBridgeManagement<Player, NetworkPlayerServerInfo> management) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (scheduler == null) {
            throw new NullPointerException("scheduler is marked non-null but is null");
        }
        if (serviceInfoHolder == null) {
            throw new NullPointerException("serviceInfoHolder is marked non-null but is null");
        }
        if (serverPlatformHelper == null) {
            throw new NullPointerException("serverPlatformHelper is marked non-null but is null");
        }
        if (management == null) {
            throw new NullPointerException("management is marked non-null but is null");
        }
        this.plugin = plugin;
        this.scheduler = scheduler;
        this.serviceInfoHolder = serviceInfoHolder;
        this.serverPlatformHelper = serverPlatformHelper;
        this.management = management;
    }

    @EventHandler
    public void handle(@NonNull PlayerJoinEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        ServiceTask task = this.management.selfTask();
        if (task != null) {
            Player player = event.getPlayer();
            if (task.maintenance() && !player.hasPermission("cloudnet.bridge.maintenance")) {
                this.management.configuration().handleMessage(Locale.US, "server-join-cancel-because-maintenance", arg_0 -> ((Player)player).disconnect(arg_0));
                return;
            }
            String permission = task.propertyHolder().getString("requiredPermission");
            if (permission != null && !player.hasPermission(permission)) {
                this.management.configuration().handleMessage(Locale.US, "server-join-cancel-because-permission", arg_0 -> ((Player)player).disconnect(arg_0));
                return;
            }
        }
        this.serverPlatformHelper.sendChannelMessageLoginSuccess(event.getPlayer().getUniqueId(), this.management.createPlayerInformation(event.getPlayer()));
        this.scheduler.runTask(this.plugin, () -> ((ServiceInfoHolder)this.serviceInfoHolder).publishServiceInfoUpdate());
    }

    @EventHandler
    public void handle(@NonNull PlayerQuitEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.serverPlatformHelper.sendChannelMessageDisconnected(event.getPlayer().getUniqueId(), this.management.ownNetworkServiceInfo());
        this.scheduler.runTask(this.plugin, () -> ((ServiceInfoHolder)this.serviceInfoHolder).publishServiceInfoUpdate());
    }
}

