/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.limboloohp;

import com.loohp.limbo.events.EventsManager;
import com.loohp.limbo.events.Listener;
import com.loohp.limbo.plugins.LimboPlugin;
import eu.cloudnetservice.driver.registry.ServiceRegistry;
import eu.cloudnetservice.driver.util.ModuleHelper;
import eu.cloudnetservice.ext.platforminject.api.PlatformEntrypoint;
import eu.cloudnetservice.ext.platforminject.api.stereotype.PlatformPlugin;
import eu.cloudnetservice.modules.bridge.platform.limboloohp.LimboLoohpBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.limboloohp.LimboLoohpPlayerManagementListener;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import lombok.NonNull;

@Singleton
@PlatformPlugin(platform="limboloohp", name="CloudNet-Bridge", version="4.0.0-RC11", description="Bridges service software support between all supported versions for easy CloudNet plugin development", authors={"CloudNetService"})
public final class LimboLoohpBridgePlugin
implements PlatformEntrypoint {
    private final LimboPlugin plugin;
    private final ModuleHelper moduleHelper;
    private final EventsManager eventsManager;
    private final ServiceRegistry serviceRegistry;
    private final LimboLoohpBridgeManagement bridgeManagement;
    private final LimboLoohpPlayerManagementListener playerListener;

    @Inject
    public LimboLoohpBridgePlugin(@NonNull LimboPlugin plugin, @NonNull ModuleHelper moduleHelper, @NonNull EventsManager eventsManager, @NonNull ServiceRegistry serviceRegistry, @NonNull LimboLoohpBridgeManagement bridgeManagement, @NonNull LimboLoohpPlayerManagementListener playerListener) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (moduleHelper == null) {
            throw new NullPointerException("moduleHelper is marked non-null but is null");
        }
        if (eventsManager == null) {
            throw new NullPointerException("eventsManager is marked non-null but is null");
        }
        if (serviceRegistry == null) {
            throw new NullPointerException("serviceRegistry is marked non-null but is null");
        }
        if (bridgeManagement == null) {
            throw new NullPointerException("bridgeManagement is marked non-null but is null");
        }
        if (playerListener == null) {
            throw new NullPointerException("playerListener is marked non-null but is null");
        }
        this.plugin = plugin;
        this.moduleHelper = moduleHelper;
        this.eventsManager = eventsManager;
        this.serviceRegistry = serviceRegistry;
        this.bridgeManagement = bridgeManagement;
        this.playerListener = playerListener;
    }

    @Override
    public void onLoad() {
        this.bridgeManagement.registerServices(this.serviceRegistry);
        this.bridgeManagement.postInit();
        this.eventsManager.registerEvents(this.plugin, (Listener)this.playerListener);
    }

    @Override
    public void onDisable() {
        this.moduleHelper.unregisterAll(this.getClass().getClassLoader());
    }
}

