/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.limboloohp;

import com.loohp.limbo.Limbo;
import com.loohp.limbo.player.Player;
import com.loohp.limbo.plugins.LimboPlugin;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.network.HostAndPort;
import eu.cloudnetservice.driver.network.NetworkClient;
import eu.cloudnetservice.driver.network.rpc.factory.RPCFactory;
import eu.cloudnetservice.driver.provider.CloudServiceProvider;
import eu.cloudnetservice.driver.provider.ServiceTaskProvider;
import eu.cloudnetservice.driver.registry.ServiceRegistry;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import eu.cloudnetservice.ext.platforminject.api.stereotype.ProvidesFor;
import eu.cloudnetservice.modules.bridge.BridgeManagement;
import eu.cloudnetservice.modules.bridge.BridgeServiceHelper;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.limboloohp.LimboLoohpDirectPlayerExecutor;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerServerInfo;
import eu.cloudnetservice.modules.bridge.player.PlayerManager;
import eu.cloudnetservice.modules.bridge.player.ServicePlayer;
import eu.cloudnetservice.modules.bridge.player.executor.PlayerExecutor;
import eu.cloudnetservice.wrapper.configuration.WrapperConfiguration;
import eu.cloudnetservice.wrapper.event.ServiceInfoPropertiesConfigureEvent;
import eu.cloudnetservice.wrapper.holder.ServiceInfoHolder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import lombok.NonNull;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.Nullable;

@Singleton
@ProvidesFor(platform="limboloohp", types={PlatformBridgeManagement.class, BridgeManagement.class})
final class LimboLoohpBridgeManagement
extends PlatformBridgeManagement<Player, NetworkPlayerServerInfo> {
    private static final BiFunction<Player, String, Boolean> PERM_FUNCTION = Player::hasPermission;
    private final Limbo limbo;
    private final LimboPlugin plugin;
    private final PlayerExecutor directGlobalExecutor;

    @Inject
    public LimboLoohpBridgeManagement(@NonNull Limbo limbo, @NonNull LimboPlugin plugin, @NonNull RPCFactory rpcFactory, @NonNull EventManager eventManager, @NonNull NetworkClient networkClient, @NonNull ServiceTaskProvider taskProvider, @NonNull BridgeServiceHelper serviceHelper, @NonNull ServiceInfoHolder serviceInfoHolder, @NonNull CloudServiceProvider serviceProvider, @NonNull WrapperConfiguration wrapperConfiguration) {
        super(rpcFactory, eventManager, networkClient, taskProvider, serviceHelper, serviceInfoHolder, serviceProvider, wrapperConfiguration);
        if (limbo == null) {
            throw new NullPointerException("limbo is marked non-null but is null");
        }
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (rpcFactory == null) {
            throw new NullPointerException("rpcFactory is marked non-null but is null");
        }
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        if (taskProvider == null) {
            throw new NullPointerException("taskProvider is marked non-null but is null");
        }
        if (serviceHelper == null) {
            throw new NullPointerException("serviceHelper is marked non-null but is null");
        }
        if (serviceInfoHolder == null) {
            throw new NullPointerException("serviceInfoHolder is marked non-null but is null");
        }
        if (serviceProvider == null) {
            throw new NullPointerException("serviceProvider is marked non-null but is null");
        }
        if (wrapperConfiguration == null) {
            throw new NullPointerException("wrapperConfiguration is marked non-null but is null");
        }
        this.limbo = limbo;
        this.plugin = plugin;
        this.directGlobalExecutor = new LimboLoohpDirectPlayerExecutor(plugin, PlayerExecutor.GLOBAL_UNIQUE_ID, () -> ((Limbo)limbo).getPlayers());
        serviceHelper.motd().set(LegacyComponentSerializer.legacySection().serialize(limbo.getServerProperties().getMotd()));
        serviceHelper.maxPlayers().set(limbo.getServerProperties().getMaxPlayers());
    }

    @Override
    public void registerServices(@NonNull ServiceRegistry registry) {
        if (registry == null) {
            throw new NullPointerException("registry is marked non-null but is null");
        }
        registry.registerProvider(PlayerManager.class, "PlayerManager", this.playerManager);
        registry.registerProvider(PlatformBridgeManagement.class, "LimboLoohpBridgeManagement", this);
    }

    @Override
    @NonNull
    public ServicePlayer wrapPlayer(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return new ServicePlayer(player.getUniqueId(), player.getName());
    }

    @Override
    @NonNull
    public NetworkPlayerServerInfo createPlayerInformation(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return new NetworkPlayerServerInfo(player.getUniqueId(), player.getName(), null, new HostAndPort(player.clientConnection.getInetAddress().getHostAddress(), player.clientConnection.getSocket().getPort()), this.ownNetworkServiceInfo);
    }

    @Override
    @NonNull
    public BiFunction<Player, String, Boolean> permissionFunction() {
        return PERM_FUNCTION;
    }

    @Override
    public boolean isOnAnyFallbackInstance(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.isOnAnyFallbackInstance(this.ownNetworkServiceInfo.serverName(), null, arg_0 -> ((Player)player).hasPermission(arg_0));
    }

    @Override
    @NonNull
    public Optional<ServiceInfoSnapshot> fallback(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.fallback(player, this.ownNetworkServiceInfo.serverName());
    }

    @Override
    @NonNull
    public Optional<ServiceInfoSnapshot> fallback(@NonNull Player player, @Nullable String currServer) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.fallback(player.getUniqueId(), currServer, null, arg_0 -> ((Player)player).hasPermission(arg_0));
    }

    @Override
    public void handleFallbackConnectionSuccess(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.handleFallbackConnectionSuccess(player.getUniqueId());
    }

    @Override
    public void removeFallbackProfile(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.removeFallbackProfile(player.getUniqueId());
    }

    @Override
    @NonNull
    public PlayerExecutor directPlayerExecutor(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return uniqueId.equals(PlayerExecutor.GLOBAL_UNIQUE_ID) ? this.directGlobalExecutor : new LimboLoohpDirectPlayerExecutor(this.plugin, uniqueId, () -> Collections.singleton(this.limbo.getPlayer(uniqueId)));
    }

    @Override
    public void appendServiceInformation(@NonNull ServiceInfoPropertiesConfigureEvent configureEvent) {
        if (configureEvent == null) {
            throw new NullPointerException("configureEvent is marked non-null but is null");
        }
        super.appendServiceInformation(configureEvent);
        configureEvent.propertyHolder().append("Version", this.limbo.getServerProperties().getVersionString());
        configureEvent.propertyHolder().append("Online-Count", this.limbo.getPlayers().size());
        configureEvent.propertyHolder().append("Players", this.limbo.getPlayers().stream().map(this::createPlayerInformation).toList());
    }
}

