/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.helper;

import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.modules.bridge.platform.helper.ProxyPlatformHelper;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerServerInfo;
import eu.cloudnetservice.modules.bridge.player.NetworkServiceInfo;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.UUID;
import lombok.NonNull;

@Singleton
public final class ServerPlatformHelper {
    private final ProxyPlatformHelper proxyPlatformHelper;

    @Inject
    public ServerPlatformHelper(@NonNull ProxyPlatformHelper proxyPlatformHelper) {
        if (proxyPlatformHelper == null) {
            throw new NullPointerException("proxyPlatformHelper is marked non-null but is null");
        }
        this.proxyPlatformHelper = proxyPlatformHelper;
    }

    public void sendChannelMessageLoginSuccess(@NonNull UUID playerUniqueId, @NonNull NetworkPlayerServerInfo info) {
        if (playerUniqueId == null) {
            throw new NullPointerException("playerUniqueId is marked non-null but is null");
        }
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        this.proxyPlatformHelper.toCurrentNode().message("server_player_login").channel("bridge_internal_player_channel").buffer(DataBuf.empty().writeUniqueId(playerUniqueId).writeObject(info)).build().send();
    }

    public void sendChannelMessageDisconnected(@NonNull UUID playerUniqueId, @NonNull NetworkServiceInfo info) {
        if (playerUniqueId == null) {
            throw new NullPointerException("playerUniqueId is marked non-null but is null");
        }
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        this.proxyPlatformHelper.toCurrentNode().message("server_player_disconnect").channel("bridge_internal_player_channel").buffer(DataBuf.empty().writeUniqueId(playerUniqueId).writeObject(info)).build().send();
    }
}

