/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.helper;

import eu.cloudnetservice.driver.ComponentInfo;
import eu.cloudnetservice.driver.channel.ChannelMessage;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.modules.bridge.node.event.LocalPlayerPreLoginEvent;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerProxyInfo;
import eu.cloudnetservice.modules.bridge.player.NetworkServiceInfo;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.UUID;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Singleton
@ApiStatus.Internal
public final class ProxyPlatformHelper {
    private final ComponentInfo componentInfo;

    @Inject
    public ProxyPlatformHelper(@NonNull ComponentInfo componentInfo) {
        if (componentInfo == null) {
            throw new NullPointerException("componentInfo is marked non-null but is null");
        }
        this.componentInfo = componentInfo;
    }

    @NonNull
    public LocalPlayerPreLoginEvent.Result sendChannelMessagePreLogin(@NonNull NetworkPlayerProxyInfo playerInfo) {
        if (playerInfo == null) {
            throw new NullPointerException("playerInfo is marked non-null but is null");
        }
        ChannelMessage result = this.toCurrentNode().message("proxy_player_pre_login").channel("bridge_internal_player_channel").buffer(DataBuf.empty().writeObject(playerInfo)).build().sendSingleQuery();
        return result == null ? LocalPlayerPreLoginEvent.Result.allowed() : result.content().readObject(LocalPlayerPreLoginEvent.Result.class);
    }

    public void sendChannelMessageLoginSuccess(@NonNull NetworkPlayerProxyInfo proxyInfo, @Nullable NetworkServiceInfo joinServiceInfo) {
        if (proxyInfo == null) {
            throw new NullPointerException("proxyInfo is marked non-null but is null");
        }
        this.toCurrentNode().message("proxy_player_login").channel("bridge_internal_player_channel").buffer(DataBuf.empty().writeObject(proxyInfo).writeObject(joinServiceInfo)).build().send();
    }

    public void sendChannelMessageServiceSwitch(@NonNull UUID playerId, @NonNull NetworkServiceInfo target) {
        if (playerId == null) {
            throw new NullPointerException("playerId is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.toCurrentNode().message("proxy_player_service_switch").channel("bridge_internal_player_channel").buffer(DataBuf.empty().writeUniqueId(playerId).writeObject(target)).build().send();
    }

    public void sendChannelMessageDisconnected(@NonNull UUID playerUniqueId) {
        if (playerUniqueId == null) {
            throw new NullPointerException("playerUniqueId is marked non-null but is null");
        }
        this.toCurrentNode().message("proxy_player_disconnect").channel("bridge_internal_player_channel").buffer(DataBuf.empty().writeUniqueId(playerUniqueId)).build().send();
    }

    @NonNull
    ChannelMessage.Builder toCurrentNode() {
        return ChannelMessage.builder().targetNode(this.componentInfo.nodeUniqueId());
    }
}

