/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.fallback;

import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;

public final class FallbackProfile {
    private final Set<String> triedServices = new HashSet<String>();

    public void reset() {
        this.triedServices.clear();
    }

    public void selectService(@NonNull String service) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        this.triedServices.add(service);
    }

    public boolean hasTried(@NonNull String service) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        return this.triedServices.contains(service);
    }
}

