/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.fabric;

import com.mojang.authlib.properties.Property;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.network.NetworkClient;
import eu.cloudnetservice.driver.network.rpc.factory.RPCFactory;
import eu.cloudnetservice.driver.provider.CloudServiceProvider;
import eu.cloudnetservice.driver.provider.ServiceTaskProvider;
import eu.cloudnetservice.driver.registry.ServiceRegistry;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import eu.cloudnetservice.modules.bridge.BridgeServiceHelper;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.fabric.FabricDirectPlayerExecutor;
import eu.cloudnetservice.modules.bridge.platform.fabric.util.BridgedServer;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerServerInfo;
import eu.cloudnetservice.modules.bridge.player.PlayerManager;
import eu.cloudnetservice.modules.bridge.player.ServicePlayer;
import eu.cloudnetservice.modules.bridge.player.executor.PlayerExecutor;
import eu.cloudnetservice.modules.bridge.util.BridgeHostAndPortUtil;
import eu.cloudnetservice.wrapper.configuration.WrapperConfiguration;
import eu.cloudnetservice.wrapper.event.ServiceInfoPropertiesConfigureEvent;
import eu.cloudnetservice.wrapper.holder.ServiceInfoHolder;
import io.netty.util.AttributeKey;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import lombok.NonNull;
import net.minecraft.class_155;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public final class FabricBridgeManagement
extends PlatformBridgeManagement<class_3222, NetworkPlayerServerInfo> {
    public static final boolean DISABLE_CLOUDNET_FORWARDING = Boolean.getBoolean("cloudnet.ipforward.disabled");
    public static final AttributeKey<UUID> PLAYER_FORWARDED_UUID_KEY = AttributeKey.newInstance((String)"cloudnet_bridge$forwardedUniqueId");
    public static final AttributeKey<Void> PLAYER_INTENTION_PACKET_SEEN_KEY = AttributeKey.newInstance((String)"cloudnet_bridge$intentionPacketSeen");
    public static final AttributeKey<Property[]> PLAYER_PROFILE_PROPERTIES_KEY = AttributeKey.newInstance((String)"cloudnet_bridge$forwardedProperties");
    private final BridgedServer server;
    private final PlayerExecutor directGlobalExecutor;

    public FabricBridgeManagement(@NonNull BridgedServer server, @NonNull RPCFactory rpcFactory, @NonNull EventManager eventManager, @NonNull NetworkClient networkClient, @NonNull ServiceTaskProvider taskProvider, @NonNull BridgeServiceHelper serviceHelper, @NonNull ServiceInfoHolder serviceInfoHolder, @NonNull CloudServiceProvider serviceProvider, @NonNull WrapperConfiguration wrapperConfiguration) {
        super(rpcFactory, eventManager, networkClient, taskProvider, serviceHelper, serviceInfoHolder, serviceProvider, wrapperConfiguration);
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        if (rpcFactory == null) {
            throw new NullPointerException("rpcFactory is marked non-null but is null");
        }
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        if (taskProvider == null) {
            throw new NullPointerException("taskProvider is marked non-null but is null");
        }
        if (serviceHelper == null) {
            throw new NullPointerException("serviceHelper is marked non-null but is null");
        }
        if (serviceInfoHolder == null) {
            throw new NullPointerException("serviceInfoHolder is marked non-null but is null");
        }
        if (serviceProvider == null) {
            throw new NullPointerException("serviceProvider is marked non-null but is null");
        }
        if (wrapperConfiguration == null) {
            throw new NullPointerException("wrapperConfiguration is marked non-null but is null");
        }
        this.server = server;
        this.directGlobalExecutor = new FabricDirectPlayerExecutor(PlayerExecutor.GLOBAL_UNIQUE_ID, (Supplier<? extends Collection<class_3222>>)((Supplier<Collection>)server::cloudnet_bridge$players));
        serviceHelper.motd().set(server.cloudnet_bridge$motd());
        serviceHelper.maxPlayers().set(server.cloudnet_bridge$maxPlayers());
    }

    @Override
    public void registerServices(@NonNull ServiceRegistry registry) {
        if (registry == null) {
            throw new NullPointerException("registry is marked non-null but is null");
        }
        registry.registerProvider(PlayerManager.class, "PlayerManager", this.playerManager);
        registry.registerProvider(PlatformBridgeManagement.class, "FabricBridgeManagement", this);
    }

    @Override
    @NonNull
    public ServicePlayer wrapPlayer(@NonNull class_3222 player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return new ServicePlayer(player.method_5667(), player.method_7334().getName());
    }

    @Override
    @NonNull
    public NetworkPlayerServerInfo createPlayerInformation(@NonNull class_3222 player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return new NetworkPlayerServerInfo(player.method_5667(), player.method_7334().getName(), null, BridgeHostAndPortUtil.fromSocketAddress(player.field_13987.method_48107()), this.ownNetworkServiceInfo);
    }

    @Override
    @NonNull
    public BiFunction<class_3222, String, Boolean> permissionFunction() {
        return (player, perm) -> true;
    }

    @Override
    public boolean isOnAnyFallbackInstance(@NonNull class_3222 player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.isOnAnyFallbackInstance(this.ownNetworkServiceInfo.serverName(), null, perm -> true);
    }

    @Override
    @NonNull
    public Optional<ServiceInfoSnapshot> fallback(@NonNull class_3222 player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.fallback(player, this.ownNetworkServiceInfo.serverName());
    }

    @Override
    @NonNull
    public Optional<ServiceInfoSnapshot> fallback(@NonNull class_3222 player, @Nullable String currServer) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.fallback(player.method_5667(), currServer, null, perm -> true);
    }

    @Override
    public void handleFallbackConnectionSuccess(@NonNull class_3222 player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.handleFallbackConnectionSuccess(player.method_5667());
    }

    @Override
    public void removeFallbackProfile(@NonNull class_3222 player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.removeFallbackProfile(player.method_5667());
    }

    @Override
    @NonNull
    public PlayerExecutor directPlayerExecutor(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return uniqueId.equals(PlayerExecutor.GLOBAL_UNIQUE_ID) ? this.directGlobalExecutor : new FabricDirectPlayerExecutor(uniqueId, (Supplier<? extends Collection<class_3222>>)((Supplier<Collection>)() -> Collections.singleton(this.server.cloudnet_bridge$player(uniqueId))));
    }

    @Override
    public void appendServiceInformation(@NonNull ServiceInfoPropertiesConfigureEvent configureEvent) {
        if (configureEvent == null) {
            throw new NullPointerException("configureEvent is marked non-null but is null");
        }
        super.appendServiceInformation(configureEvent);
        configureEvent.propertyHolder().append("Online-Count", this.server.cloudnet_bridge$playerCount());
        configureEvent.propertyHolder().append("Version", class_155.method_16673().method_48019());
        configureEvent.propertyHolder().append("Players", this.server.cloudnet_bridge$players().stream().map(this::createPlayerInformation).toList());
    }
}

