/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.bungeecord.command;

import eu.cloudnetservice.ext.component.ComponentFormats;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import lombok.NonNull;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.plugin.Command;

public final class BungeeCordHubCommand
extends Command {
    private final ProxyServer proxyServer;
    private final PlatformBridgeManagement<ProxiedPlayer, ?> management;

    public BungeeCordHubCommand(@NonNull ProxyServer proxyServer, @NonNull PlatformBridgeManagement<ProxiedPlayer, ?> management, @NonNull String name, String ... aliases) {
        super(name, null, aliases);
        if (proxyServer == null) {
            throw new NullPointerException("proxyServer is marked non-null but is null");
        }
        if (management == null) {
            throw new NullPointerException("management is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (aliases == null) {
            throw new NullPointerException("aliases is marked non-null but is null");
        }
        this.management = management;
        this.proxyServer = proxyServer;
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof ProxiedPlayer) {
            ProxiedPlayer player = (ProxiedPlayer)sender;
            if (this.management.isOnAnyFallbackInstance(player)) {
                this.management.configuration().handleMessage(player.getLocale(), "command-hub-already-in-hub", ComponentFormats.ADVENTURE_TO_BUNGEE::convert, arg_0 -> ((ProxiedPlayer)player).sendMessage(arg_0));
            } else {
                ServerInfo hub = this.management.fallback(player).map(service -> this.proxyServer.getServerInfo(service.name())).orElse(null);
                if (hub != null) {
                    player.connect(hub, (result, ex) -> {
                        if (result.booleanValue() && ex == null) {
                            this.management.configuration().handleMessage(player.getLocale(), "command-hub-success-connect", message -> ComponentFormats.ADVENTURE_TO_BUNGEE.convert(message.replace("%server%", hub.getName())), arg_0 -> ((ProxiedPlayer)player).sendMessage(arg_0));
                        } else {
                            this.management.configuration().handleMessage(player.getLocale(), "command-hub-no-server-found", ComponentFormats.ADVENTURE_TO_BUNGEE::convert, arg_0 -> ((ProxiedPlayer)player).sendMessage(arg_0));
                        }
                    }, ServerConnectEvent.Reason.COMMAND);
                }
            }
        }
    }
}

