/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.bungeecord.command;

import eu.cloudnetservice.driver.provider.ClusterNodeProvider;
import eu.cloudnetservice.ext.component.ComponentFormats;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import lombok.NonNull;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.TabExecutor;

@Singleton
public final class BungeeCordCloudCommand
extends Command
implements TabExecutor {
    private final ClusterNodeProvider clusterNodeProvider;
    private final PlatformBridgeManagement<?, ?> management;

    @Inject
    public BungeeCordCloudCommand(@NonNull ClusterNodeProvider clusterNodeProvider, @NonNull PlatformBridgeManagement<?, ?> management) {
        super("cloudnet", "cloudnet.command.cloudnet", new String[]{"cloud"});
        if (clusterNodeProvider == null) {
            throw new NullPointerException("clusterNodeProvider is marked non-null but is null");
        }
        if (management == null) {
            throw new NullPointerException("management is marked non-null but is null");
        }
        this.clusterNodeProvider = clusterNodeProvider;
        this.management = management;
    }

    public void execute(@NonNull CommandSender sender, @NonNull String[] args) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        if (args.length == 0) {
            sender.sendMessage(ComponentFormats.ADVENTURE_TO_BUNGEE.convert(this.management.configuration().prefix() + "/cloudnet <command>"));
            return;
        }
        String commandLine = String.join((CharSequence)" ", args);
        if (sender instanceof ProxiedPlayer) {
            ProxiedPlayer player = (ProxiedPlayer)sender;
            this.clusterNodeProvider.consoleCommandAsync(args[0]).thenAcceptAsync(info -> {
                if (info != null && sender.hasPermission(info.permission())) {
                    this.executeNow(sender, commandLine);
                    return;
                }
                this.management.configuration().handleMessage(player.getLocale(), "command-cloud-sub-command-no-permission", message -> ComponentFormats.ADVENTURE_TO_BUNGEE.convert(message.replace("%command%", args[0])), arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
            });
        } else {
            this.executeNow(sender, commandLine);
        }
    }

    private void executeNow(@NonNull CommandSender sender, @NonNull String commandLine) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (commandLine == null) {
            throw new NullPointerException("commandLine is marked non-null but is null");
        }
        for (String output : this.clusterNodeProvider.sendCommandLine(commandLine)) {
            sender.sendMessage(ComponentFormats.ADVENTURE_TO_BUNGEE.convert(this.management.configuration().prefix() + output));
        }
    }

    @NonNull
    public Iterable<String> onTabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        return this.clusterNodeProvider.consoleTabCompleteResults(String.join((CharSequence)" ", args));
    }
}

