/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.bungeecord;

import dev.derklaro.reflexion.MethodAccessor;
import dev.derklaro.reflexion.Reflexion;
import eu.cloudnetservice.driver.service.ServiceTask;
import eu.cloudnetservice.ext.component.ComponentFormats;
import eu.cloudnetservice.modules.bridge.node.event.LocalPlayerPreLoginEvent;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.helper.ProxyPlatformHelper;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerProxyInfo;
import eu.cloudnetservice.modules.bridge.player.NetworkServiceInfo;
import eu.cloudnetservice.modules.bridge.util.BridgeHostAndPortUtil;
import eu.cloudnetservice.wrapper.holder.ServiceInfoHolder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.event.ServerKickEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.TaskScheduler;
import net.md_5.bungee.event.EventHandler;

@Singleton
public final class BungeeCordPlayerManagementListener
implements Listener {
    private static final int PROTOCOL_1_20_2 = 764;
    private static final MethodAccessor<?> PLAYER_DIMENSION_ACCESSOR = Reflexion.get("net.md_5.bungee.UserConnection", null).findMethod("getDimension", new Class[0]).orElseThrow();
    private final Plugin plugin;
    private final ProxyServer proxyServer;
    private final TaskScheduler scheduler;
    private final ServiceInfoHolder serviceInfoHolder;
    private final ProxyPlatformHelper proxyPlatformHelper;
    private final PlatformBridgeManagement<ProxiedPlayer, NetworkPlayerProxyInfo> management;

    @Inject
    public BungeeCordPlayerManagementListener(@NonNull Plugin plugin, @NonNull ProxyServer proxyServer, @NonNull TaskScheduler scheduler, @NonNull ServiceInfoHolder serviceInfoHolder, @NonNull ProxyPlatformHelper proxyPlatformHelper, @NonNull PlatformBridgeManagement<ProxiedPlayer, NetworkPlayerProxyInfo> management) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (proxyServer == null) {
            throw new NullPointerException("proxyServer is marked non-null but is null");
        }
        if (scheduler == null) {
            throw new NullPointerException("scheduler is marked non-null but is null");
        }
        if (serviceInfoHolder == null) {
            throw new NullPointerException("serviceInfoHolder is marked non-null but is null");
        }
        if (proxyPlatformHelper == null) {
            throw new NullPointerException("proxyPlatformHelper is marked non-null but is null");
        }
        if (management == null) {
            throw new NullPointerException("management is marked non-null but is null");
        }
        this.plugin = plugin;
        this.proxyServer = proxyServer;
        this.scheduler = scheduler;
        this.serviceInfoHolder = serviceInfoHolder;
        this.proxyPlatformHelper = proxyPlatformHelper;
        this.management = management;
    }

    @EventHandler(priority=-64)
    public void handle(@NonNull ServerConnectEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        ProxiedPlayer player = event.getPlayer();
        if (event.getReason() == ServerConnectEvent.Reason.JOIN_PROXY) {
            LocalPlayerPreLoginEvent.Result loginResult;
            ServiceTask task = this.management.selfTask();
            if (task != null) {
                if (task.maintenance() && !player.hasPermission("cloudnet.bridge.maintenance")) {
                    event.setCancelled(true);
                    this.management.configuration().handleMessage(player.getLocale(), "proxy-join-cancel-because-maintenance", ComponentFormats.ADVENTURE_TO_BUNGEE::convert, arg_0 -> ((ProxiedPlayer)player).disconnect(arg_0));
                    return;
                }
                String permission = task.propertyHolder().getString("requiredPermission");
                if (permission != null && !player.hasPermission(permission)) {
                    event.setCancelled(true);
                    this.management.configuration().handleMessage(player.getLocale(), "proxy-join-cancel-because-permission", ComponentFormats.ADVENTURE_TO_BUNGEE::convert, arg_0 -> ((ProxiedPlayer)player).disconnect(arg_0));
                    return;
                }
            }
            if (!(loginResult = this.proxyPlatformHelper.sendChannelMessagePreLogin(new NetworkPlayerProxyInfo(player.getUniqueId(), player.getName(), null, player.getPendingConnection().getVersion(), BridgeHostAndPortUtil.fromSocketAddress(player.getSocketAddress()), BridgeHostAndPortUtil.fromSocketAddress(player.getPendingConnection().getListener().getSocketAddress()), player.getPendingConnection().isOnlineMode(), this.management.ownNetworkServiceInfo()))).permitLogin()) {
                event.setCancelled(true);
                player.disconnect(TextComponent.fromLegacyText((String)LegacyComponentSerializer.legacySection().serialize(loginResult.result())));
                return;
            }
        }
        if (event.getReason() == ServerConnectEvent.Reason.JOIN_PROXY || event.getReason() == ServerConnectEvent.Reason.LOBBY_FALLBACK) {
            ServerInfo target = this.management.fallback(player).map(service -> this.proxyServer.getServerInfo(service.name())).orElse(null);
            if (target != null) {
                event.setTarget(target);
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=-64)
    public void handle(@NonNull ServerKickEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (event.getPlayer().isConnected()) {
            ServerInfo target = this.management.fallback(event.getPlayer(), event.getKickedFrom().getName()).map(service -> this.proxyServer.getServerInfo(service.name())).orElse(null);
            if (target != null) {
                Server curServer = event.getPlayer().getServer();
                if (event.getState() == ServerKickEvent.State.CONNECTING && curServer != null && curServer.getInfo().equals((Object)target)) {
                    this.management.handleFallbackConnectionSuccess(event.getPlayer());
                }
                event.setCancelled(true);
                event.setCancelServer(target);
                this.management.configuration().handleMessage(event.getPlayer().getLocale(), "error-connecting-to-server", message -> ComponentFormats.ADVENTURE_TO_BUNGEE.convert(message.replace("%server%", event.getKickedFrom().getName()).replace("%reason%", BaseComponent.toLegacyText((BaseComponent[])event.getKickReasonComponent()))), arg_0 -> ((ProxiedPlayer)event.getPlayer()).sendMessage(arg_0));
            } else {
                event.setCancelled(false);
                event.setCancelServer(null);
                this.management.configuration().handleMessage(event.getPlayer().getLocale(), "proxy-join-disconnect-because-no-hub", ComponentFormats.ADVENTURE_TO_BUNGEE::convert, arg_0 -> ((ServerKickEvent)event).setKickReasonComponent(arg_0));
            }
        }
    }

    @EventHandler
    public void handle(@NonNull ServerConnectedEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        NetworkServiceInfo joinedServiceInfo = this.management.cachedService(service -> service.name().equals(event.getServer().getInfo().getName())).map(NetworkServiceInfo::fromServiceInfoSnapshot).orElse(null);
        if (this.initialConnect(event.getPlayer())) {
            this.proxyPlatformHelper.sendChannelMessageLoginSuccess(this.management.createPlayerInformation(event.getPlayer()), joinedServiceInfo);
            this.serviceInfoHolder.publishServiceInfoUpdate();
        } else if (joinedServiceInfo != null) {
            this.proxyPlatformHelper.sendChannelMessageServiceSwitch(event.getPlayer().getUniqueId(), joinedServiceInfo);
        }
        this.management.handleFallbackConnectionSuccess(event.getPlayer());
    }

    @EventHandler
    public void handle(@NonNull PlayerDisconnectEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (event.getPlayer().getServer() != null) {
            this.proxyPlatformHelper.sendChannelMessageDisconnected(event.getPlayer().getUniqueId());
            this.scheduler.schedule(this.plugin, () -> ((ServiceInfoHolder)this.serviceInfoHolder).publishServiceInfoUpdate(), 50L, TimeUnit.MILLISECONDS);
        }
        this.management.removeFallbackProfile(event.getPlayer());
    }

    private boolean initialConnect(@NonNull ProxiedPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (player.getPendingConnection().getVersion() >= 764) {
            return PLAYER_DIMENSION_ACCESSOR.invoke(player).getOrThrow() == null;
        }
        return player.getServer() == null;
    }
}

