/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.bungeecord;

import dev.derklaro.reflexion.Reflexion;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.InetSocketAddress;
import java.util.function.Consumer;
import lombok.NonNull;
import net.md_5.bungee.api.ProxyConfig;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;

@Singleton
public final class BungeeCordHelper {
    private final ProxyServer proxyServer;
    private final Consumer<ServiceInfoSnapshot> serverRegisterHandler;
    private final Consumer<ServiceInfoSnapshot> serverUnregisterHandler;

    @Inject
    public BungeeCordHelper(@NonNull ProxyServer proxyServer, @NonNull ProxyConfig proxyConfig) {
        if (proxyServer == null) {
            throw new NullPointerException("proxyServer is marked non-null but is null");
        }
        if (proxyConfig == null) {
            throw new NullPointerException("proxyConfig is marked non-null but is null");
        }
        this.proxyServer = proxyServer;
        this.serverRegisterHandler = Reflexion.onBound(proxyConfig).findMethod("addServer", ServerInfo.class).map(acc -> service -> acc.invokeWithArgs(this.constructServerInfo((ServiceInfoSnapshot)service))).orElse(service -> {
            ServerInfo serverInfo = this.constructServerInfo((ServiceInfoSnapshot)service);
            proxyServer.getServers().put(service.name(), serverInfo);
        });
        this.serverUnregisterHandler = Reflexion.onBound(proxyConfig).findMethod("removeServerNamed", String.class).map(acc -> service -> acc.invokeWithArgs(service.name())).orElse(service -> proxyServer.getServers().remove(service.name()));
    }

    @NonNull
    Consumer<ServiceInfoSnapshot> serverRegisterHandler() {
        return this.serverRegisterHandler;
    }

    @NonNull
    Consumer<ServiceInfoSnapshot> serverUnregisterHandler() {
        return this.serverUnregisterHandler;
    }

    @NonNull
    private ServerInfo constructServerInfo(@NonNull ServiceInfoSnapshot snapshot) {
        if (snapshot == null) {
            throw new NullPointerException("snapshot is marked non-null but is null");
        }
        return this.proxyServer.constructServerInfo(snapshot.name(), new InetSocketAddress(snapshot.address().host(), snapshot.address().port()), "Just another CloudNet provided service info", false);
    }
}

