/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.bungeecord;

import eu.cloudnetservice.common.tuple.Tuple2;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.PlatformPlayerExecutorAdapter;
import eu.cloudnetservice.modules.bridge.player.executor.ServerSelectorType;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.plugin.PluginManager;
import org.jetbrains.annotations.Nullable;

final class BungeeCordDirectPlayerExecutor
extends PlatformPlayerExecutorAdapter<ProxiedPlayer> {
    private static final int PROTOCOL_VERSION_1_16 = 735;
    private final ProxyServer proxyServer;
    private final PluginManager pluginManager;
    private final PlatformBridgeManagement<ProxiedPlayer, ?> management;

    public BungeeCordDirectPlayerExecutor(@NonNull ProxyServer proxyServer, @NonNull UUID uniqueId, @NonNull PlatformBridgeManagement<ProxiedPlayer, ?> management, @NonNull Supplier<Collection<? extends ProxiedPlayer>> playerSupplier) {
        super(uniqueId, playerSupplier);
        if (proxyServer == null) {
            throw new NullPointerException("proxyServer is marked non-null but is null");
        }
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        if (management == null) {
            throw new NullPointerException("management is marked non-null but is null");
        }
        if (playerSupplier == null) {
            throw new NullPointerException("playerSupplier is marked non-null but is null");
        }
        this.proxyServer = proxyServer;
        this.pluginManager = proxyServer.getPluginManager();
        this.management = management;
    }

    @Override
    public void connect(@NonNull String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is marked non-null but is null");
        }
        ServerInfo serverInfo = this.proxyServer.getServerInfo(serviceName);
        if (serverInfo != null) {
            this.forEach(player -> player.connect(serverInfo, ServerConnectEvent.Reason.PLUGIN));
        }
    }

    @Override
    public void connectSelecting(@NonNull ServerSelectorType selectorType) {
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
        this.management.cachedServices().stream().sorted(selectorType.comparator()).map(service -> this.proxyServer.getServerInfo(service.name())).filter(Objects::nonNull).findFirst().ifPresent(server -> this.forEach(player -> player.connect(server, ServerConnectEvent.Reason.PLUGIN)));
    }

    @Override
    public void connectToFallback() {
        ((Collection)this.playerSupplier.get()).stream().filter(Objects::nonNull).map(player -> new Tuple2<ProxiedPlayer, Optional<ServiceInfoSnapshot>>((ProxiedPlayer)player, this.management.fallback((ProxiedPlayer)player))).filter(pair -> ((Optional)pair.second()).isPresent()).map(p -> new Tuple2<ProxiedPlayer, ServerInfo>((ProxiedPlayer)p.first(), this.proxyServer.getServerInfo(((ServiceInfoSnapshot)((Optional)p.second()).get()).name()))).filter(pair -> pair.second() != null).findFirst().ifPresent(pair -> ((ProxiedPlayer)pair.first()).connect((ServerInfo)pair.second(), ServerConnectEvent.Reason.PLUGIN));
    }

    @Override
    public void connectToGroup(@NonNull String group, @NonNull ServerSelectorType selectorType) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
        this.management.cachedServices().stream().filter(service -> service.configuration().groups().contains(group)).sorted(selectorType.comparator()).map(service -> this.proxyServer.getServerInfo(service.name())).filter(Objects::nonNull).findFirst().ifPresent(server -> this.forEach(player -> player.connect(server, ServerConnectEvent.Reason.PLUGIN)));
    }

    @Override
    public void connectToTask(@NonNull String task, @NonNull ServerSelectorType selectorType) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
        this.management.cachedServices().stream().filter(service -> service.serviceId().taskName().equals(task)).sorted(selectorType.comparator()).map(service -> this.proxyServer.getServerInfo(service.name())).filter(Objects::nonNull).findFirst().ifPresent(server -> this.forEach(player -> player.connect(server, ServerConnectEvent.Reason.PLUGIN)));
    }

    @Override
    public void kick(@NonNull Component message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.forEach(player -> player.disconnect(this.convertComponent(message, (ProxiedPlayer)player)));
    }

    @Override
    protected void sendTitle(@NonNull Component title, @NonNull Component subtitle, int fadeIn, int stay, int fadeOut) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (subtitle == null) {
            throw new NullPointerException("subtitle is marked non-null but is null");
        }
        this.forEach(player -> this.proxyServer.createTitle().title(this.convertComponent(title, (ProxiedPlayer)player)).subTitle(this.convertComponent(subtitle, (ProxiedPlayer)player)).fadeIn(fadeIn).stay(stay).fadeOut(fadeOut).send(player));
    }

    @Override
    public void sendChatMessage(@NonNull Component message, @Nullable String permission) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.forEach(player -> {
            if (permission == null || player.hasPermission(permission)) {
                player.sendMessage(this.convertComponent(message, (ProxiedPlayer)player));
            }
        });
    }

    @Override
    public void sendPluginMessage(@NonNull String key, byte[] data) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.forEach(player -> player.sendData(key, data));
    }

    @Override
    public void spoofCommandExecution(@NonNull String command, boolean redirectToServer) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        this.forEach(player -> {
            if (!this.pluginManager.dispatchCommand((CommandSender)player, command) && redirectToServer) {
                player.chat("/" + command);
            }
        });
    }

    @NonNull
    private BaseComponent[] convertComponent(@NonNull Component component, @NonNull ProxiedPlayer player) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (player.getPendingConnection().getVersion() < 735) {
            return BungeeComponentSerializer.legacy().serialize(component);
        }
        return BungeeComponentSerializer.get().serialize(component);
    }
}

