/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.bungeecord;

import com.google.inject.Singleton;
import eu.cloudnetservice.driver.registry.ServiceRegistry;
import eu.cloudnetservice.driver.util.ModuleHelper;
import eu.cloudnetservice.ext.platforminject.api.PlatformEntrypoint;
import eu.cloudnetservice.ext.platforminject.api.stereotype.PlatformPlugin;
import eu.cloudnetservice.modules.bridge.platform.bungeecord.BungeeCordBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.bungeecord.BungeeCordPlayerManagementListener;
import eu.cloudnetservice.modules.bridge.platform.bungeecord.command.BungeeCordCloudCommand;
import eu.cloudnetservice.modules.bridge.platform.bungeecord.command.BungeeCordFakeReloadCommand;
import eu.cloudnetservice.modules.bridge.platform.bungeecord.command.BungeeCordHubCommand;
import jakarta.inject.Inject;
import java.util.Arrays;
import lombok.NonNull;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginManager;

@Singleton
@PlatformPlugin(platform="bungeecord", name="CloudNet-Bridge", version="4.0.0-RC11", description="Bridges service software support between all supported versions for easy CloudNet plugin development", authors={"CloudNetService"})
public final class BungeeCordBridgePlugin
implements PlatformEntrypoint {
    private final Plugin plugin;
    private final ProxyServer proxyServer;
    private final ModuleHelper moduleHelper;
    private final PluginManager pluginManager;
    private final ServiceRegistry serviceRegistry;
    private final BungeeCordCloudCommand cloudCommand;
    private final BungeeCordBridgeManagement bridgeManagement;
    private final BungeeCordPlayerManagementListener playerListener;

    @Inject
    public BungeeCordBridgePlugin(@NonNull Plugin plugin, @NonNull ProxyServer proxyServer, @NonNull ModuleHelper moduleHelper, @NonNull PluginManager pluginManager, @NonNull ServiceRegistry serviceRegistry, @NonNull BungeeCordCloudCommand cloudCommand, @NonNull BungeeCordBridgeManagement bridgeManagement, @NonNull BungeeCordPlayerManagementListener playerListener) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (proxyServer == null) {
            throw new NullPointerException("proxyServer is marked non-null but is null");
        }
        if (moduleHelper == null) {
            throw new NullPointerException("moduleHelper is marked non-null but is null");
        }
        if (pluginManager == null) {
            throw new NullPointerException("pluginManager is marked non-null but is null");
        }
        if (serviceRegistry == null) {
            throw new NullPointerException("serviceRegistry is marked non-null but is null");
        }
        if (cloudCommand == null) {
            throw new NullPointerException("cloudCommand is marked non-null but is null");
        }
        if (bridgeManagement == null) {
            throw new NullPointerException("bridgeManagement is marked non-null but is null");
        }
        if (playerListener == null) {
            throw new NullPointerException("playerListener is marked non-null but is null");
        }
        this.plugin = plugin;
        this.proxyServer = proxyServer;
        this.moduleHelper = moduleHelper;
        this.pluginManager = pluginManager;
        this.serviceRegistry = serviceRegistry;
        this.cloudCommand = cloudCommand;
        this.bridgeManagement = bridgeManagement;
        this.playerListener = playerListener;
    }

    @Override
    public void onLoad() {
        this.bridgeManagement.registerServices(this.serviceRegistry);
        this.bridgeManagement.postInit();
        this.pluginManager.registerListener(this.plugin, (Listener)this.playerListener);
        this.pluginManager.registerCommand(this.plugin, (Command)new BungeeCordFakeReloadCommand());
        this.pluginManager.registerCommand(this.plugin, (Command)this.cloudCommand);
        if (!this.bridgeManagement.configuration().hubCommandNames().isEmpty()) {
            String[] names = this.bridgeManagement.configuration().hubCommandNames().toArray(new String[0]);
            this.pluginManager.registerCommand(this.plugin, (Command)new BungeeCordHubCommand(this.proxyServer, this.bridgeManagement, names[0], names.length > 1 ? Arrays.copyOfRange(names, 1, names.length) : new String[]{}));
        }
    }

    @Override
    public void onDisable() {
        this.moduleHelper.unregisterAll(this.getClass().getClassLoader());
    }
}

