/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.bungeecord;

import com.google.common.collect.Iterables;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.network.NetworkClient;
import eu.cloudnetservice.driver.network.rpc.factory.RPCFactory;
import eu.cloudnetservice.driver.provider.CloudServiceProvider;
import eu.cloudnetservice.driver.provider.ServiceTaskProvider;
import eu.cloudnetservice.driver.registry.ServiceRegistry;
import eu.cloudnetservice.driver.service.ServiceEnvironmentType;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import eu.cloudnetservice.ext.platforminject.api.stereotype.ProvidesFor;
import eu.cloudnetservice.modules.bridge.BridgeManagement;
import eu.cloudnetservice.modules.bridge.BridgeServiceHelper;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.bungeecord.BungeeCordDirectPlayerExecutor;
import eu.cloudnetservice.modules.bridge.platform.bungeecord.BungeeCordHelper;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerProxyInfo;
import eu.cloudnetservice.modules.bridge.player.PlayerManager;
import eu.cloudnetservice.modules.bridge.player.ServicePlayer;
import eu.cloudnetservice.modules.bridge.player.executor.PlayerExecutor;
import eu.cloudnetservice.modules.bridge.util.BridgeHostAndPortUtil;
import eu.cloudnetservice.wrapper.configuration.WrapperConfiguration;
import eu.cloudnetservice.wrapper.event.ServiceInfoPropertiesConfigureEvent;
import eu.cloudnetservice.wrapper.holder.ServiceInfoHolder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import lombok.NonNull;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import org.jetbrains.annotations.Nullable;

@Singleton
@ProvidesFor(platform="bungeecord", types={PlatformBridgeManagement.class, BridgeManagement.class})
final class BungeeCordBridgeManagement
extends PlatformBridgeManagement<ProxiedPlayer, NetworkPlayerProxyInfo> {
    private static final BiFunction<ProxiedPlayer, String, Boolean> PERM_FUNCTION = CommandSender::hasPermission;
    private final ProxyServer proxyServer;
    private final PlayerExecutor globalDirectPlayerExecutor;

    @Inject
    public BungeeCordBridgeManagement(@NonNull RPCFactory rpcFactory, @NonNull ProxyServer proxyServer, @NonNull EventManager eventManager, @NonNull NetworkClient networkClient, @NonNull BungeeCordHelper bungeeHelper, @NonNull ServiceTaskProvider taskProvider, @NonNull BridgeServiceHelper serviceHelper, @NonNull ServiceInfoHolder serviceInfoHolder, @NonNull CloudServiceProvider serviceProvider, @NonNull WrapperConfiguration wrapperConfiguration) {
        super(rpcFactory, eventManager, networkClient, taskProvider, serviceHelper, serviceInfoHolder, serviceProvider, wrapperConfiguration);
        if (rpcFactory == null) {
            throw new NullPointerException("rpcFactory is marked non-null but is null");
        }
        if (proxyServer == null) {
            throw new NullPointerException("proxyServer is marked non-null but is null");
        }
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        if (bungeeHelper == null) {
            throw new NullPointerException("bungeeHelper is marked non-null but is null");
        }
        if (taskProvider == null) {
            throw new NullPointerException("taskProvider is marked non-null but is null");
        }
        if (serviceHelper == null) {
            throw new NullPointerException("serviceHelper is marked non-null but is null");
        }
        if (serviceInfoHolder == null) {
            throw new NullPointerException("serviceInfoHolder is marked non-null but is null");
        }
        if (serviceProvider == null) {
            throw new NullPointerException("serviceProvider is marked non-null but is null");
        }
        if (wrapperConfiguration == null) {
            throw new NullPointerException("wrapperConfiguration is marked non-null but is null");
        }
        this.proxyServer = proxyServer;
        this.globalDirectPlayerExecutor = new BungeeCordDirectPlayerExecutor(proxyServer, PlayerExecutor.GLOBAL_UNIQUE_ID, this, () -> ((ProxyServer)proxyServer).getPlayers());
        serviceHelper.motd().set(((ListenerInfo)Iterables.get(this.proxyServer.getConfig().getListeners(), 0)).getMotd());
        serviceHelper.maxPlayers().set(this.proxyServer.getConfig().getPlayerLimit());
        this.cacheTester = CONNECTED_SERVICE_TESTER.and(service -> service.serviceId().environment().readProperty(ServiceEnvironmentType.JAVA_SERVER));
        this.cacheRegisterListener = bungeeHelper.serverRegisterHandler();
        this.cacheUnregisterListener = bungeeHelper.serverUnregisterHandler();
    }

    @Override
    public void registerServices(@NonNull ServiceRegistry registry) {
        if (registry == null) {
            throw new NullPointerException("registry is marked non-null but is null");
        }
        registry.registerProvider(PlayerManager.class, "PlayerManager", this.playerManager);
        registry.registerProvider(PlatformBridgeManagement.class, "BungeeCordBridgeManagement", this);
    }

    @Override
    @NonNull
    public ServicePlayer wrapPlayer(@NonNull ProxiedPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return new ServicePlayer(player.getUniqueId(), player.getName());
    }

    @Override
    @NonNull
    public NetworkPlayerProxyInfo createPlayerInformation(@NonNull ProxiedPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return new NetworkPlayerProxyInfo(player.getUniqueId(), player.getName(), null, player.getPendingConnection().getVersion(), BridgeHostAndPortUtil.fromSocketAddress(player.getSocketAddress()), BridgeHostAndPortUtil.fromSocketAddress(player.getPendingConnection().getListener().getSocketAddress()), player.getPendingConnection().isOnlineMode(), this.ownNetworkServiceInfo);
    }

    @Override
    @NonNull
    public BiFunction<ProxiedPlayer, String, Boolean> permissionFunction() {
        return PERM_FUNCTION;
    }

    @Override
    public boolean isOnAnyFallbackInstance(@NonNull ProxiedPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.isOnAnyFallbackInstance(player.getServer() == null ? null : player.getServer().getInfo().getName(), this.getVirtualHostString(player.getPendingConnection()), arg_0 -> ((ProxiedPlayer)player).hasPermission(arg_0));
    }

    @Override
    @NonNull
    public Optional<ServiceInfoSnapshot> fallback(@NonNull ProxiedPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.fallback(player, player.getServer() == null ? null : player.getServer().getInfo().getName());
    }

    @Override
    @NonNull
    public Optional<ServiceInfoSnapshot> fallback(@NonNull ProxiedPlayer player, @Nullable String currServer) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.fallback(player.getUniqueId(), currServer, this.getVirtualHostString(player.getPendingConnection()), arg_0 -> ((ProxiedPlayer)player).hasPermission(arg_0));
    }

    @Override
    public void handleFallbackConnectionSuccess(@NonNull ProxiedPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.handleFallbackConnectionSuccess(player.getUniqueId());
    }

    @Override
    public void removeFallbackProfile(@NonNull ProxiedPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.removeFallbackProfile(player.getUniqueId());
    }

    @Override
    @NonNull
    public PlayerExecutor directPlayerExecutor(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return uniqueId.equals(PlayerExecutor.GLOBAL_UNIQUE_ID) ? this.globalDirectPlayerExecutor : new BungeeCordDirectPlayerExecutor(this.proxyServer, uniqueId, this, () -> Collections.singleton(this.proxyServer.getPlayer(uniqueId)));
    }

    @Override
    public void appendServiceInformation(@NonNull ServiceInfoPropertiesConfigureEvent configureEvent) {
        if (configureEvent == null) {
            throw new NullPointerException("configureEvent is marked non-null but is null");
        }
        super.appendServiceInformation(configureEvent);
        configureEvent.propertyHolder().append("Version", this.proxyServer.getVersion());
        configureEvent.propertyHolder().append("Online-Count", this.proxyServer.getPlayers().size());
        configureEvent.propertyHolder().append("Players", this.proxyServer.getPlayers().stream().map(this::createPlayerInformation).toList());
    }

    @Nullable
    private String getVirtualHostString(@NonNull PendingConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        return connection.getVirtualHost() == null ? null : connection.getVirtualHost().getHostString();
    }
}

