/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.bukkit;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import lombok.NonNull;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

final class BukkitUtil {
    private static final Function<Player, String> LOCALE_GETTER;
    private static final Map<String, Locale> LOCALE_CACHE;

    private BukkitUtil() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public static Locale playerLocale(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        String localeTag = LOCALE_GETTER.apply(player);
        if (localeTag == null) {
            return null;
        }
        return LOCALE_CACHE.computeIfAbsent(localeTag, tag -> Locale.forLanguageTag(tag.replace('_', '-')));
    }

    static {
        Function<Player, String> localeGetter;
        LOCALE_CACHE = new HashMap<String, Locale>();
        try {
            Player.Spigot.class.getMethod("getLocale", new Class[0]);
            localeGetter = player -> player.spigot().getLocale();
        }
        catch (NoSuchMethodException exception) {
            try {
                MethodHandle getLocale = MethodHandles.publicLookup().findVirtual(Player.class, "getLocale", MethodType.methodType(String.class));
                localeGetter = player -> {
                    try {
                        return getLocale.invoke((Player)player);
                    }
                    catch (Throwable throwable) {
                        return null;
                    }
                };
            }
            catch (IllegalAccessException | NoSuchMethodException ignored) {
                localeGetter = $2 -> null;
            }
        }
        LOCALE_GETTER = localeGetter;
    }
}

