/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.bukkit;

import eu.cloudnetservice.modules.bridge.platform.PlatformPlayerExecutorAdapter;
import eu.cloudnetservice.modules.bridge.player.executor.ServerSelectorType;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Supplier;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

final class BukkitDirectPlayerExecutor
extends PlatformPlayerExecutorAdapter<Player> {
    private final Plugin plugin;

    public BukkitDirectPlayerExecutor(@NonNull Plugin plugin, @NonNull UUID target, @NonNull Supplier<Collection<? extends Player>> playerSupplier) {
        super(target, playerSupplier);
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (playerSupplier == null) {
            throw new NullPointerException("playerSupplier is marked non-null but is null");
        }
        this.plugin = plugin;
    }

    @Override
    public void connect(@NonNull String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is marked non-null but is null");
        }
    }

    @Override
    public void connectSelecting(@NonNull ServerSelectorType selectorType) {
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
    }

    @Override
    public void connectToFallback() {
    }

    @Override
    public void connectToGroup(@NonNull String group, @NonNull ServerSelectorType selectorType) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
    }

    @Override
    public void connectToTask(@NonNull String task, @NonNull ServerSelectorType selectorType) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
    }

    @Override
    public void kick(@NonNull Component message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.plugin.getServer().getScheduler().runTask(this.plugin, () -> this.forEach(player -> player.kickPlayer(LegacyComponentSerializer.legacySection().serialize(message))));
    }

    @Override
    protected void sendTitle(@NonNull Component title, @NonNull Component subtitle, int fadeIn, int stay, int fadeOut) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (subtitle == null) {
            throw new NullPointerException("subtitle is marked non-null but is null");
        }
        this.forEach(player -> player.sendTitle(LegacyComponentSerializer.legacySection().serialize(title), LegacyComponentSerializer.legacySection().serialize(subtitle)));
    }

    @Override
    public void sendChatMessage(@NonNull Component message, @Nullable String permission) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.forEach(player -> {
            if (permission == null || player.hasPermission(permission)) {
                player.sendMessage(LegacyComponentSerializer.legacySection().serialize(message));
            }
        });
    }

    @Override
    public void sendPluginMessage(@NonNull String key, byte[] data) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.forEach(player -> player.sendPluginMessage(this.plugin, key, data));
    }

    @Override
    public void spoofCommandExecution(@NonNull String command, boolean redirectToServer) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        Server server = this.plugin.getServer();
        server.getScheduler().runTask(this.plugin, () -> this.forEach(player -> server.dispatchCommand((CommandSender)player, command)));
    }
}

