/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.bukkit;

import eu.cloudnetservice.driver.registry.ServiceRegistry;
import eu.cloudnetservice.driver.util.ModuleHelper;
import eu.cloudnetservice.ext.platforminject.api.PlatformEntrypoint;
import eu.cloudnetservice.ext.platforminject.api.stereotype.PlatformPlugin;
import eu.cloudnetservice.modules.bridge.platform.bukkit.BukkitBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.bukkit.BukkitPlayerManagementListener;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import lombok.NonNull;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

@Singleton
@PlatformPlugin(platform="bukkit", name="CloudNet-Bridge", version="4.0.0-RC11", description="Bridges service software support between all supported versions for easy CloudNet plugin development", authors={"CloudNetService"})
public final class BukkitBridgePlugin
implements PlatformEntrypoint {
    private final Plugin plugin;
    private final ModuleHelper moduleHelper;
    private final PluginManager pluginManager;
    private final ServiceRegistry serviceRegistry;
    private final BukkitBridgeManagement bridgeManagement;
    private final BukkitPlayerManagementListener playerListener;

    @Inject
    public BukkitBridgePlugin(@NonNull Plugin plugin, @NonNull ModuleHelper moduleHelper, @NonNull PluginManager pluginManager, @NonNull ServiceRegistry serviceRegistry, @NonNull BukkitBridgeManagement bridgeManagement, @NonNull BukkitPlayerManagementListener playerListener) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (moduleHelper == null) {
            throw new NullPointerException("moduleHelper is marked non-null but is null");
        }
        if (pluginManager == null) {
            throw new NullPointerException("pluginManager is marked non-null but is null");
        }
        if (serviceRegistry == null) {
            throw new NullPointerException("serviceRegistry is marked non-null but is null");
        }
        if (bridgeManagement == null) {
            throw new NullPointerException("bridgeManagement is marked non-null but is null");
        }
        if (playerListener == null) {
            throw new NullPointerException("playerListener is marked non-null but is null");
        }
        this.plugin = plugin;
        this.moduleHelper = moduleHelper;
        this.pluginManager = pluginManager;
        this.serviceRegistry = serviceRegistry;
        this.bridgeManagement = bridgeManagement;
        this.playerListener = playerListener;
    }

    @Override
    public void onLoad() {
        this.bridgeManagement.registerServices(this.serviceRegistry);
        this.bridgeManagement.postInit();
        this.pluginManager.registerEvents((Listener)this.playerListener, this.plugin);
    }

    @Override
    public void onDisable() {
        this.moduleHelper.unregisterAll(this.getClass().getClassLoader());
    }
}

