/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.bukkit;

import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.network.NetworkClient;
import eu.cloudnetservice.driver.network.rpc.factory.RPCFactory;
import eu.cloudnetservice.driver.provider.CloudServiceProvider;
import eu.cloudnetservice.driver.provider.ServiceTaskProvider;
import eu.cloudnetservice.driver.registry.ServiceRegistry;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import eu.cloudnetservice.ext.platforminject.api.stereotype.ProvidesFor;
import eu.cloudnetservice.modules.bridge.BridgeManagement;
import eu.cloudnetservice.modules.bridge.BridgeServiceHelper;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.bukkit.BukkitDirectPlayerExecutor;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerServerInfo;
import eu.cloudnetservice.modules.bridge.player.PlayerManager;
import eu.cloudnetservice.modules.bridge.player.ServicePlayer;
import eu.cloudnetservice.modules.bridge.player.executor.PlayerExecutor;
import eu.cloudnetservice.modules.bridge.util.BridgeHostAndPortUtil;
import eu.cloudnetservice.wrapper.configuration.WrapperConfiguration;
import eu.cloudnetservice.wrapper.event.ServiceInfoPropertiesConfigureEvent;
import eu.cloudnetservice.wrapper.holder.ServiceInfoHolder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

@Singleton
@ProvidesFor(platform="bukkit", types={PlatformBridgeManagement.class, BridgeManagement.class})
final class BukkitBridgeManagement
extends PlatformBridgeManagement<Player, NetworkPlayerServerInfo> {
    private static final BiFunction<Player, String, Boolean> PERM_FUNCTION = Permissible::hasPermission;
    private final Server server;
    private final Plugin plugin;
    private final PlayerExecutor directGlobalExecutor;

    @Inject
    public BukkitBridgeManagement(@NonNull Server server, @NonNull Plugin plugin, @NonNull RPCFactory rpcFactory, @NonNull EventManager eventManager, @NonNull NetworkClient networkClient, @NonNull ServiceTaskProvider taskProvider, @NonNull BridgeServiceHelper serviceHelper, @NonNull ServiceInfoHolder serviceInfoHolder, @NonNull CloudServiceProvider serviceProvider, @NonNull WrapperConfiguration wrapperConfiguration) {
        super(rpcFactory, eventManager, networkClient, taskProvider, serviceHelper, serviceInfoHolder, serviceProvider, wrapperConfiguration);
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (rpcFactory == null) {
            throw new NullPointerException("rpcFactory is marked non-null but is null");
        }
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        if (taskProvider == null) {
            throw new NullPointerException("taskProvider is marked non-null but is null");
        }
        if (serviceHelper == null) {
            throw new NullPointerException("serviceHelper is marked non-null but is null");
        }
        if (serviceInfoHolder == null) {
            throw new NullPointerException("serviceInfoHolder is marked non-null but is null");
        }
        if (serviceProvider == null) {
            throw new NullPointerException("serviceProvider is marked non-null but is null");
        }
        if (wrapperConfiguration == null) {
            throw new NullPointerException("wrapperConfiguration is marked non-null but is null");
        }
        this.server = server;
        this.plugin = plugin;
        this.directGlobalExecutor = new BukkitDirectPlayerExecutor(plugin, PlayerExecutor.GLOBAL_UNIQUE_ID, Bukkit::getOnlinePlayers);
        serviceHelper.motd().set(server.getMotd());
        serviceHelper.maxPlayers().set(server.getMaxPlayers());
    }

    @Override
    public void registerServices(@NonNull ServiceRegistry registry) {
        if (registry == null) {
            throw new NullPointerException("registry is marked non-null but is null");
        }
        registry.registerProvider(PlayerManager.class, "PlayerManager", this.playerManager);
        registry.registerProvider(PlatformBridgeManagement.class, "BukkitBridgeManagement", this);
    }

    @Override
    @NonNull
    public ServicePlayer wrapPlayer(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return new ServicePlayer(player.getUniqueId(), player.getName());
    }

    @Override
    @NonNull
    public NetworkPlayerServerInfo createPlayerInformation(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return new NetworkPlayerServerInfo(player.getUniqueId(), player.getName(), null, BridgeHostAndPortUtil.fromSocketAddress(player.getAddress()), this.ownNetworkServiceInfo);
    }

    @Override
    @NonNull
    public BiFunction<Player, String, Boolean> permissionFunction() {
        return PERM_FUNCTION;
    }

    @Override
    public boolean isOnAnyFallbackInstance(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.isOnAnyFallbackInstance(this.ownNetworkServiceInfo.serverName(), null, arg_0 -> ((Player)player).hasPermission(arg_0));
    }

    @Override
    @NonNull
    public Optional<ServiceInfoSnapshot> fallback(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.fallback(player, this.ownNetworkServiceInfo.serverName());
    }

    @Override
    @NonNull
    public Optional<ServiceInfoSnapshot> fallback(@NonNull Player player, @Nullable String currServer) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.fallback(player.getUniqueId(), currServer, null, arg_0 -> ((Player)player).hasPermission(arg_0));
    }

    @Override
    public void handleFallbackConnectionSuccess(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.handleFallbackConnectionSuccess(player.getUniqueId());
    }

    @Override
    public void removeFallbackProfile(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.removeFallbackProfile(player.getUniqueId());
    }

    @Override
    @NonNull
    public PlayerExecutor directPlayerExecutor(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return uniqueId.equals(PlayerExecutor.GLOBAL_UNIQUE_ID) ? this.directGlobalExecutor : new BukkitDirectPlayerExecutor(this.plugin, uniqueId, () -> Collections.singleton(this.server.getPlayer(uniqueId)));
    }

    @Override
    public void appendServiceInformation(@NonNull ServiceInfoPropertiesConfigureEvent configureEvent) {
        if (configureEvent == null) {
            throw new NullPointerException("configureEvent is marked non-null but is null");
        }
        super.appendServiceInformation(configureEvent);
        configureEvent.propertyHolder().append("Version", this.server.getVersion());
        configureEvent.propertyHolder().append("Online-Count", this.server.getOnlinePlayers().size());
        configureEvent.propertyHolder().append("Players", this.server.getOnlinePlayers().stream().map(this::createPlayerInformation).toList());
    }
}

