/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform;

import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.rpc.RPC;
import eu.cloudnetservice.driver.network.rpc.RPCSender;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCInvocationTarget;
import eu.cloudnetservice.driver.network.rpc.factory.RPCFactory;
import eu.cloudnetservice.driver.network.rpc.factory.RPCImplementationBuilder;
import eu.cloudnetservice.modules.bridge.platform.PlatformPlayerExecutor;
import eu.cloudnetservice.modules.bridge.player.PlayerManager;
import eu.cloudnetservice.modules.bridge.player.PlayerProvider;
import eu.cloudnetservice.modules.bridge.player.executor.PlayerExecutor;
import java.util.UUID;
import java.util.function.Supplier;
import lombok.NonNull;

abstract class PlatformPlayerManager
implements PlayerManager {
    private final RPCSender sender;
    private final RPCImplementationBuilder.InstanceAllocator<PlayerProvider> playerProviderAllocator;
    private final RPCImplementationBuilder.InstanceAllocator<? extends PlayerExecutor> playerExecutorAllocator;
    private final PlayerProvider allPlayers;
    private final PlayerExecutor globalPlayerExecutor;

    @RPCInvocationTarget
    public PlatformPlayerManager(@NonNull RPCSender sender, @NonNull Supplier<NetworkChannel> channelSupplier) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (channelSupplier == null) {
            throw new NullPointerException("channelSupplier is marked non-null but is null");
        }
        this.sender = sender;
        RPCFactory rpcFactory = sender.sourceFactory();
        this.playerProviderAllocator = rpcFactory.newRPCBasedImplementationBuilder(PlayerProvider.class).implementConcreteMethods().targetChannel(channelSupplier).generateImplementation();
        this.playerExecutorAllocator = rpcFactory.newRPCBasedImplementationBuilder(PlatformPlayerExecutor.class).superclass(PlayerExecutor.class).targetChannel(channelSupplier).generateImplementation();
        RPC allPlayerBaseRPC = this.sender.invokeMethod("onlinePlayers", new Object[0]);
        this.allPlayers = this.playerProviderAllocator.withBaseRPC(allPlayerBaseRPC).allocate();
        this.globalPlayerExecutor = this.playerExecutor(PlayerExecutor.GLOBAL_UNIQUE_ID);
    }

    @Override
    @NonNull
    public PlayerProvider onlinePlayers() {
        return this.allPlayers;
    }

    @Override
    @NonNull
    public PlayerProvider taskOnlinePlayers(@NonNull String task) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        RPC baseRPC = this.sender.invokeCaller(task);
        return this.playerProviderAllocator.withBaseRPC(baseRPC).allocate();
    }

    @Override
    @NonNull
    public PlayerProvider groupOnlinePlayers(@NonNull String group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        RPC baseRPC = this.sender.invokeCaller(group);
        return this.playerProviderAllocator.withBaseRPC(baseRPC).allocate();
    }

    @Override
    @NonNull
    public PlayerExecutor globalPlayerExecutor() {
        return this.globalPlayerExecutor;
    }

    @Override
    @NonNull
    public PlayerExecutor playerExecutor(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        RPC baseRPC = this.sender.invokeCaller(uniqueId);
        return this.playerExecutorAllocator.withBaseRPC(baseRPC).withAdditionalConstructorParameters(uniqueId).allocate();
    }
}

