/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform;

import eu.cloudnetservice.modules.bridge.player.executor.PlayerExecutor;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;

public abstract class PlatformPlayerExecutorAdapter<T>
implements PlayerExecutor {
    protected final UUID uniqueId;
    protected final Supplier<? extends Collection<? extends T>> playerSupplier;

    public PlatformPlayerExecutorAdapter(@NonNull UUID uniqueId, @NonNull Supplier<? extends Collection<? extends T>> supplier) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        this.uniqueId = uniqueId;
        this.playerSupplier = supplier;
    }

    @Override
    @NonNull
    public UUID uniqueId() {
        return this.uniqueId;
    }

    @Override
    public void sendTitle(@NonNull Title title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        Title.Times times = title.times();
        if (times == null) {
            times = Title.DEFAULT_TIMES;
        }
        this.sendTitle(title.title(), title.subtitle(), (int)times.fadeIn().toMillis() / 50, (int)times.stay().toMillis() / 50, (int)times.fadeOut().toMillis() / 50);
    }

    protected void sendTitle(@NonNull Component title, @NonNull Component subtitle, int fadeIn, int stay, int fadeOut) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (subtitle == null) {
            throw new NullPointerException("subtitle is marked non-null but is null");
        }
    }

    protected void forEach(@NonNull Consumer<T> consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        this.playerSupplier.get().forEach((? super T player) -> {
            if (player != null) {
                consumer.accept(player);
            }
        });
    }
}

