/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import eu.cloudnetservice.common.tuple.Tuple2;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.network.NetworkClient;
import eu.cloudnetservice.driver.network.rpc.RPCSender;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCInternalInstanceFactory;
import eu.cloudnetservice.driver.network.rpc.defaults.object.DefaultObjectMapper;
import eu.cloudnetservice.driver.network.rpc.factory.RPCFactory;
import eu.cloudnetservice.driver.provider.CloudServiceProvider;
import eu.cloudnetservice.driver.provider.ServiceTaskProvider;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import eu.cloudnetservice.driver.service.ServiceLifeCycle;
import eu.cloudnetservice.driver.service.ServiceTask;
import eu.cloudnetservice.modules.bridge.BridgeDocProperties;
import eu.cloudnetservice.modules.bridge.BridgeManagement;
import eu.cloudnetservice.modules.bridge.BridgeServiceHelper;
import eu.cloudnetservice.modules.bridge.config.BridgeConfiguration;
import eu.cloudnetservice.modules.bridge.config.ProxyFallback;
import eu.cloudnetservice.modules.bridge.config.ProxyFallbackConfiguration;
import eu.cloudnetservice.modules.bridge.event.BridgeConfigurationUpdateEvent;
import eu.cloudnetservice.modules.bridge.platform.PlatformPlayerManager;
import eu.cloudnetservice.modules.bridge.platform.fallback.FallbackProfile;
import eu.cloudnetservice.modules.bridge.platform.listener.PlatformChannelMessageListener;
import eu.cloudnetservice.modules.bridge.platform.listener.PlatformInformationListener;
import eu.cloudnetservice.modules.bridge.player.NetworkServiceInfo;
import eu.cloudnetservice.modules.bridge.player.PlayerManager;
import eu.cloudnetservice.modules.bridge.player.ServicePlayer;
import eu.cloudnetservice.modules.bridge.player.executor.PlayerExecutor;
import eu.cloudnetservice.modules.bridge.rpc.ComponentObjectSerializer;
import eu.cloudnetservice.modules.bridge.rpc.TitleObjectSerializer;
import eu.cloudnetservice.wrapper.configuration.WrapperConfiguration;
import eu.cloudnetservice.wrapper.event.ServiceInfoPropertiesConfigureEvent;
import eu.cloudnetservice.wrapper.holder.ServiceInfoHolder;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.jetbrains.annotations.Nullable;

public abstract class PlatformBridgeManagement<P, I>
implements BridgeManagement {
    protected static final Predicate<ServiceInfoSnapshot> CONNECTED_SERVICE_TESTER = service -> service.connected() && service.lifeCycle() == ServiceLifeCycle.RUNNING && service.readProperty(BridgeDocProperties.IS_ONLINE) != false;
    protected final RPCSender sender;
    protected final EventManager eventManager;
    protected final PlayerManager playerManager;
    protected final ServiceTaskProvider taskProvider;
    protected final ServiceInfoHolder serviceInfoHolder;
    protected final CloudServiceProvider serviceProvider;
    protected final BridgeServiceHelper bridgeServiceHelper;
    protected final NetworkServiceInfo ownNetworkServiceInfo;
    protected final WrapperConfiguration wrapperConfig;
    protected final LoadingCache<UUID, FallbackProfile> fallbackProfiles;
    protected final Map<UUID, ServiceInfoSnapshot> cachedServices;
    protected volatile ServiceTask selfTask;
    protected volatile BridgeConfiguration configuration;
    protected volatile ProxyFallbackConfiguration currentFallbackConfiguration;
    protected volatile Predicate<ServiceInfoSnapshot> cacheTester;
    protected volatile Consumer<ServiceInfoSnapshot> cacheRegisterListener;
    protected volatile Consumer<ServiceInfoSnapshot> cacheUnregisterListener;

    public PlatformBridgeManagement(@NonNull RPCFactory rpcFactory, @NonNull EventManager eventManager, @NonNull NetworkClient networkClient, @NonNull ServiceTaskProvider taskProvider, @NonNull BridgeServiceHelper serviceHelper, @NonNull ServiceInfoHolder serviceInfoHolder, @NonNull CloudServiceProvider serviceProvider, @NonNull WrapperConfiguration wrapperConfig) {
        if (rpcFactory == null) {
            throw new NullPointerException("rpcFactory is marked non-null but is null");
        }
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        if (taskProvider == null) {
            throw new NullPointerException("taskProvider is marked non-null but is null");
        }
        if (serviceHelper == null) {
            throw new NullPointerException("serviceHelper is marked non-null but is null");
        }
        if (serviceInfoHolder == null) {
            throw new NullPointerException("serviceInfoHolder is marked non-null but is null");
        }
        if (serviceProvider == null) {
            throw new NullPointerException("serviceProvider is marked non-null but is null");
        }
        if (wrapperConfig == null) {
            throw new NullPointerException("wrapperConfig is marked non-null but is null");
        }
        this.eventManager = eventManager;
        this.taskProvider = taskProvider;
        this.bridgeServiceHelper = serviceHelper;
        this.serviceInfoHolder = serviceInfoHolder;
        this.serviceProvider = serviceProvider;
        this.wrapperConfig = wrapperConfig;
        this.cachedServices = new ConcurrentHashMap<UUID, ServiceInfoSnapshot>();
        this.fallbackProfiles = Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).build($2 -> new FallbackProfile());
        this.cacheTester = $2 -> false;
        this.cacheUnregisterListener = $2 -> {};
        this.cacheRegisterListener = this.cacheUnregisterListener;
        DefaultObjectMapper.DEFAULT_MAPPER.registerBinding((Type)((Object)Title.class), new TitleObjectSerializer(), false).registerBinding((Type)((Object)Component.class), new ComponentObjectSerializer(), false);
        this.sender = rpcFactory.newRPCSenderBuilder(BridgeManagement.class).targetComponent(networkClient).build();
        this.playerManager = rpcFactory.newRPCBasedImplementationBuilder(PlatformPlayerManager.class).targetComponent(networkClient).superclass(PlayerManager.class).generateImplementation().withAdditionalConstructorParameters(new Object[]{RPCInternalInstanceFactory.SpecialArg.RPC_SENDER, RPCInternalInstanceFactory.SpecialArg.CHANNEL_SUPPLIER}).allocate();
        this.ownNetworkServiceInfo = NetworkServiceInfo.fromServiceInfoSnapshot(wrapperConfig.serviceInfoSnapshot());
        this.configurationSilently((BridgeConfiguration)this.sender.invokeMethod("configuration", new Object[0]).fireSync());
        eventManager.registerListener(new PlatformInformationListener(this));
        eventManager.registerListener(new PlatformChannelMessageListener(this.eventManager, this));
    }

    @Override
    @NonNull
    public BridgeConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public void configuration(@NonNull BridgeConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.sender.invokeCaller(configuration).fireSync();
    }

    public void configurationSilently(@NonNull BridgeConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.configuration = configuration;
        this.eventManager.callEvent(new BridgeConfigurationUpdateEvent(configuration));
        this.currentFallbackConfiguration = configuration.fallbackConfigurations().stream().filter(config -> this.wrapperConfig.serviceConfiguration().groups().contains(config.targetGroup())).findFirst().orElse(null);
    }

    public void appendServiceInformation(@NonNull ServiceInfoPropertiesConfigureEvent configureEvent) {
        if (configureEvent == null) {
            throw new NullPointerException("configureEvent is marked non-null but is null");
        }
        configureEvent.propertyHolder().append("Online", Boolean.TRUE);
        configureEvent.propertyHolder().append("Motd", this.bridgeServiceHelper.motd().get());
        configureEvent.propertyHolder().append("Extra", this.bridgeServiceHelper.extra().get());
        configureEvent.propertyHolder().append("State", this.bridgeServiceHelper.state().get());
        configureEvent.propertyHolder().append("Max-Players", this.bridgeServiceHelper.maxPlayers().get());
    }

    @NonNull
    public Collection<ServiceInfoSnapshot> cachedServices() {
        return this.cachedServices.values();
    }

    @Nullable
    public ServiceTask selfTask() {
        return this.selfTask;
    }

    public void handleTaskUpdate(@NonNull String name, @Nullable ServiceTask task) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (this.wrapperConfig.serviceConfiguration().serviceId().taskName().equals(name)) {
            this.selfTask = task;
        }
    }

    @NonNull
    public Optional<ServiceInfoSnapshot> cachedService(@NonNull Predicate<ServiceInfoSnapshot> filter) {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        return this.cachedServices.values().stream().filter(filter).findFirst();
    }

    @NonNull
    public Optional<ServiceInfoSnapshot> cachedService(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return Optional.ofNullable(this.cachedServices.get(uniqueId));
    }

    public void handleServiceUpdate(@NonNull ServiceInfoSnapshot snapshot) {
        if (snapshot == null) {
            throw new NullPointerException("snapshot is marked non-null but is null");
        }
        if (!this.cachedServices.containsKey(snapshot.serviceId().uniqueId())) {
            if (this.cacheTester.test(snapshot)) {
                this.cacheRegisterListener.accept(snapshot);
                this.cachedServices.put(snapshot.serviceId().uniqueId(), snapshot);
            }
        } else if (this.cacheTester.test(snapshot)) {
            this.cachedServices.replace(snapshot.serviceId().uniqueId(), snapshot);
        } else {
            this.cacheUnregisterListener.accept(snapshot);
            this.cachedServices.remove(snapshot.serviceId().uniqueId());
        }
    }

    @NonNull
    public Optional<ServiceInfoSnapshot> fallback(@NonNull UUID playerId, @Nullable String currentServerName, @Nullable String virtualHost, @NonNull Function<String, Boolean> permissionTester) {
        if (playerId == null) {
            throw new NullPointerException("playerId is marked non-null but is null");
        }
        if (permissionTester == null) {
            throw new NullPointerException("permissionTester is marked non-null but is null");
        }
        ProxyFallbackConfiguration config = this.currentFallbackConfiguration;
        if (config == null) {
            return Optional.empty();
        }
        FallbackProfile profile = this.fallbackProfiles.get(playerId);
        return this.possibleFallbacks(currentServerName, virtualHost, permissionTester).map(fallback -> new Tuple2<ProxyFallback, Optional<ServiceInfoSnapshot>>((ProxyFallback)fallback, this.anyTaskService(fallback.task(), profile, currentServerName))).filter(possibility -> ((Optional)possibility.second()).isPresent()).min(Comparator.comparing(Tuple2::first)).map(Tuple2::second).map(service -> {
            service.ifPresent(ser -> profile.selectService(ser.name()));
            return service;
        }).orElseGet(() -> {
            if (config.defaultFallbackTask() == null) {
                return Optional.empty();
            }
            return this.anyTaskService(config.defaultFallbackTask(), profile, currentServerName).map(service -> {
                profile.selectService(service.name());
                return service;
            });
        });
    }

    @NonNull
    public Stream<ProxyFallback> possibleFallbacks(@Nullable String currentServerName, @Nullable String virtualHost, @NonNull Function<String, Boolean> permissionTester) {
        if (permissionTester == null) {
            throw new NullPointerException("permissionTester is marked non-null but is null");
        }
        ProxyFallbackConfiguration config = this.currentFallbackConfiguration;
        if (config == null) {
            return Stream.empty();
        }
        Set currentGroups = this.cachedService((ServiceInfoSnapshot service) -> service.name().equals(currentServerName)).map(service -> service.configuration().groups()).orElse(Collections.emptySet());
        return config.fallbacks().stream().filter(fallback -> fallback.forcedHost() == null || currentServerName == null && fallback.forcedHost().equalsIgnoreCase(virtualHost)).filter(fallback -> fallback.permission() == null || (Boolean)permissionTester.apply(fallback.permission()) != false).filter(fallback -> {
            if (fallback.availableOnGroups().isEmpty()) return true;
            if (!fallback.availableOnGroups().stream().anyMatch(currentGroups::contains)) return false;
            return true;
        });
    }

    public boolean isOnAnyFallbackInstance(@Nullable String currentServerName, @Nullable String virtualHost, @NonNull Function<String, Boolean> permissionTester) {
        if (permissionTester == null) {
            throw new NullPointerException("permissionTester is marked non-null but is null");
        }
        ProxyFallbackConfiguration config = this.currentFallbackConfiguration;
        if (config == null) {
            return false;
        }
        return this.cachedService((ServiceInfoSnapshot service) -> service.name().equals(currentServerName)).map(service -> {
            if (config.defaultFallbackTask() != null && service.serviceId().taskName().equals(config.defaultFallbackTask())) {
                return true;
            }
            return this.possibleFallbacks(currentServerName, virtualHost, permissionTester).anyMatch(fallback -> service.serviceId().taskName().equals(fallback.task()));
        }).orElse(false);
    }

    @NonNull
    protected Optional<ServiceInfoSnapshot> anyTaskService(@NonNull String task, @NonNull FallbackProfile profile, @Nullable String currentServerName) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        return this.cachedServices.values().stream().filter(service -> service.serviceId().taskName().equals(task)).filter(service -> !profile.hasTried(service.name())).filter(service -> service.connected() && service.readProperty(BridgeDocProperties.IS_ONLINE) != false).filter(service -> currentServerName == null || !service.name().equals(currentServerName)).min((optionA, optionB) -> {
            Integer playersOnOptionA = optionA.readProperty(BridgeDocProperties.ONLINE_COUNT);
            Integer playersOnOptionB = optionB.readProperty(BridgeDocProperties.ONLINE_COUNT);
            return Integer.compare(playersOnOptionA, playersOnOptionB);
        });
    }

    public void handleFallbackConnectionSuccess(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        FallbackProfile profile = (FallbackProfile)this.fallbackProfiles.getIfPresent(uniqueId);
        if (profile != null) {
            profile.reset();
        }
    }

    public void removeFallbackProfile(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        this.fallbackProfiles.invalidate(uniqueId);
    }

    @Override
    public void postInit() {
        this.serviceInfoHolder.publishServiceInfoUpdate();
        this.serviceProvider.servicesAsync().thenAccept(services -> {
            for (ServiceInfoSnapshot service : services) {
                this.handleServiceUpdate(service);
            }
        });
        this.selfTask = this.taskProvider.serviceTask(this.wrapperConfig.serviceConfiguration().serviceId().taskName());
    }

    @NonNull
    public NetworkServiceInfo ownNetworkServiceInfo() {
        return this.ownNetworkServiceInfo;
    }

    @NonNull
    public abstract ServicePlayer wrapPlayer(@NonNull P var1);

    @NonNull
    public abstract I createPlayerInformation(@NonNull P var1);

    @NonNull
    public abstract BiFunction<P, String, Boolean> permissionFunction();

    public abstract boolean isOnAnyFallbackInstance(@NonNull P var1);

    @NonNull
    public abstract Optional<ServiceInfoSnapshot> fallback(@NonNull P var1);

    @NonNull
    public abstract Optional<ServiceInfoSnapshot> fallback(@NonNull P var1, @Nullable String var2);

    public abstract void handleFallbackConnectionSuccess(@NonNull P var1);

    public abstract void removeFallbackProfile(@NonNull P var1);

    @NonNull
    public abstract PlayerExecutor directPlayerExecutor(@NonNull UUID var1);
}

