/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.node.player;

import eu.cloudnetservice.modules.bridge.player.CloudOfflinePlayer;
import eu.cloudnetservice.modules.bridge.player.CloudPlayer;
import eu.cloudnetservice.modules.bridge.player.PlayerProvider;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

final class NodePlayerProvider
implements PlayerProvider {
    private final Supplier<Stream<CloudPlayer>> playerSupplier;

    public NodePlayerProvider(@NonNull Supplier<Stream<CloudPlayer>> playerSupplier) {
        if (playerSupplier == null) {
            throw new NullPointerException("playerSupplier is marked non-null but is null");
        }
        this.playerSupplier = playerSupplier;
    }

    @Override
    @NonNull
    public Collection<CloudPlayer> players() {
        return this.playerSupplier.get().toList();
    }

    @Override
    @NonNull
    public Collection<UUID> uniqueIds() {
        return this.playerSupplier.get().map(CloudOfflinePlayer::uniqueId).collect(Collectors.toSet());
    }

    @Override
    @NonNull
    public Collection<String> names() {
        return this.playerSupplier.get().map(CloudOfflinePlayer::name).collect(Collectors.toSet());
    }

    @Override
    public int count() {
        return (int)this.playerSupplier.get().count();
    }
}

