/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.node.player;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Striped;
import dev.derklaro.aerogel.PostConstruct;
import dev.derklaro.aerogel.auto.Provides;
import eu.cloudnetservice.driver.channel.ChannelMessage;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.rpc.factory.RPCFactory;
import eu.cloudnetservice.driver.network.rpc.handler.RPCHandler;
import eu.cloudnetservice.driver.network.rpc.handler.RPCHandlerRegistry;
import eu.cloudnetservice.driver.service.ServiceEnvironmentType;
import eu.cloudnetservice.modules.bridge.event.BridgeDeleteCloudOfflinePlayerEvent;
import eu.cloudnetservice.modules.bridge.event.BridgeProxyPlayerDisconnectEvent;
import eu.cloudnetservice.modules.bridge.event.BridgeProxyPlayerLoginEvent;
import eu.cloudnetservice.modules.bridge.event.BridgeUpdateCloudOfflinePlayerEvent;
import eu.cloudnetservice.modules.bridge.event.BridgeUpdateCloudPlayerEvent;
import eu.cloudnetservice.modules.bridge.node.command.PlayersCommand;
import eu.cloudnetservice.modules.bridge.node.listener.BridgeLocalProxyPlayerDisconnectListener;
import eu.cloudnetservice.modules.bridge.node.network.NodePlayerChannelMessageListener;
import eu.cloudnetservice.modules.bridge.node.player.NodePlayerExecutor;
import eu.cloudnetservice.modules.bridge.node.player.NodePlayerProvider;
import eu.cloudnetservice.modules.bridge.player.CloudOfflinePlayer;
import eu.cloudnetservice.modules.bridge.player.CloudPlayer;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerProxyInfo;
import eu.cloudnetservice.modules.bridge.player.NetworkServiceInfo;
import eu.cloudnetservice.modules.bridge.player.PlayerManager;
import eu.cloudnetservice.modules.bridge.player.PlayerProvider;
import eu.cloudnetservice.modules.bridge.player.executor.PlayerExecutor;
import eu.cloudnetservice.node.cluster.sync.DataSyncHandler;
import eu.cloudnetservice.node.cluster.sync.DataSyncRegistry;
import eu.cloudnetservice.node.command.CommandProvider;
import eu.cloudnetservice.node.database.LocalDatabase;
import eu.cloudnetservice.node.database.NodeDatabaseProvider;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Predicate;
import lombok.NonNull;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

@Singleton
@Provides(value={PlayerManager.class})
public class NodePlayerManager
implements PlayerManager {
    protected final String databaseName;
    protected final EventManager eventManager;
    protected final CommandProvider commandProvider;
    protected final NodeDatabaseProvider nodeDatabaseProvider;
    protected final Map<UUID, CloudPlayer> onlinePlayers = new ConcurrentHashMap<UUID, CloudPlayer>();
    protected final PlayerProvider allPlayerProvider = new NodePlayerProvider(() -> this.onlinePlayers.values().stream());
    protected final Striped<Lock> playerReadWriteLocks = Striped.lazyWeakLock(1);
    protected final LoadingCache<UUID, Optional<CloudOfflinePlayer>> offlinePlayerCache = Caffeine.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(uniqueId -> {
        Document document = this.database().get(uniqueId.toString());
        if (document == null) {
            return Optional.empty();
        }
        return Optional.of(document.toInstanceOf(CloudOfflinePlayer.class));
    });

    @Inject
    public NodePlayerManager(@NonNull EventManager eventManager, @NonNull RPCFactory providerFactory, @NonNull CommandProvider commandProvider, @NonNull DataSyncRegistry dataSyncRegistry, @NonNull RPCHandlerRegistry handlerRegistry, @NonNull NodeDatabaseProvider nodeDatabaseProvider) {
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (providerFactory == null) {
            throw new NullPointerException("providerFactory is marked non-null but is null");
        }
        if (commandProvider == null) {
            throw new NullPointerException("commandProvider is marked non-null but is null");
        }
        if (dataSyncRegistry == null) {
            throw new NullPointerException("dataSyncRegistry is marked non-null but is null");
        }
        if (handlerRegistry == null) {
            throw new NullPointerException("handlerRegistry is marked non-null but is null");
        }
        if (nodeDatabaseProvider == null) {
            throw new NullPointerException("nodeDatabaseProvider is marked non-null but is null");
        }
        this.databaseName = "cloudnet_cloud_players";
        this.eventManager = eventManager;
        this.commandProvider = commandProvider;
        this.nodeDatabaseProvider = nodeDatabaseProvider;
        RPCHandler playerManagerHandler = providerFactory.newRPCHandlerBuilder(PlayerManager.class).targetInstance(this).build();
        handlerRegistry.registerHandler(playerManagerHandler);
        RPCHandler playerExecutorHandler = providerFactory.newRPCHandlerBuilder(PlayerExecutor.class).build();
        handlerRegistry.registerHandler(playerExecutorHandler);
        RPCHandler playerProviderHandler = providerFactory.newRPCHandlerBuilder(PlayerProvider.class).build();
        handlerRegistry.registerHandler(playerProviderHandler);
        dataSyncRegistry.registerHandler(DataSyncHandler.builder().alwaysForce().key("cloud_player").convertObject(CloudPlayer.class).nameExtractor(CloudOfflinePlayer::name).dataCollector(this.onlinePlayers::values).currentGetter(player -> this.onlinePlayers.get(player.uniqueId())).writer(player -> this.onlinePlayers.put(player.uniqueId(), (CloudPlayer)player)).build());
    }

    @PostConstruct
    private void registerPlayerCommand() {
        this.commandProvider.register(PlayersCommand.class);
    }

    @PostConstruct
    private void registerListeners() {
        this.eventManager.registerListener(BridgeLocalProxyPlayerDisconnectListener.class);
        this.eventManager.registerListener(NodePlayerChannelMessageListener.class);
    }

    @Override
    public int onlineCount() {
        return this.onlinePlayers.size();
    }

    @Override
    public long registeredCount() {
        return this.database().documentCount();
    }

    @Override
    @Nullable
    public CloudPlayer onlinePlayer(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return this.onlinePlayers.get(uniqueId);
    }

    @Override
    @Nullable
    public CloudPlayer firstOnlinePlayer(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        for (CloudPlayer player : this.onlinePlayers.values()) {
            if (!player.name().equalsIgnoreCase(name)) continue;
            return player;
        }
        return null;
    }

    @Override
    @NonNull
    public List<CloudPlayer> onlinePlayers(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.onlinePlayers.values().stream().filter(cloudPlayer -> cloudPlayer.name().equalsIgnoreCase(name)).toList();
    }

    @Override
    @NonNull
    public List<CloudPlayer> environmentOnlinePlayers(@NonNull ServiceEnvironmentType environment) {
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        return this.onlinePlayers.values().stream().filter(cloudPlayer -> {
            NetworkServiceInfo serviceInfo = Objects.requireNonNullElse(cloudPlayer.connectedService(), cloudPlayer.loginService());
            return serviceInfo.environment().equals(environment);
        }).toList();
    }

    @Override
    @NonNull
    public PlayerProvider onlinePlayers() {
        return this.allPlayerProvider;
    }

    @Override
    @NonNull
    public PlayerProvider taskOnlinePlayers(@NonNull String task) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        return new NodePlayerProvider(() -> this.onlinePlayers.values().stream().filter(player -> {
            NetworkServiceInfo serviceInfo = Objects.requireNonNullElse(player.connectedService(), player.loginService());
            return serviceInfo.taskName().equals(task);
        }));
    }

    @Override
    @NonNull
    public PlayerProvider groupOnlinePlayers(@NonNull String group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return new NodePlayerProvider(() -> this.onlinePlayers.values().stream().filter(player -> {
            NetworkServiceInfo serviceInfo = Objects.requireNonNullElse(player.connectedService(), player.loginService());
            return serviceInfo.groups().contains(group);
        }));
    }

    @Override
    @Nullable
    public CloudOfflinePlayer offlinePlayer(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return this.offlinePlayerCache.get(uniqueId).orElse(null);
    }

    @Override
    @Nullable
    public CloudOfflinePlayer firstOfflinePlayer(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.offlinePlayerCache.asMap().values().stream().filter(Optional::isPresent).map(Optional::get).filter(player -> player.name().equalsIgnoreCase(name)).findFirst().orElseGet(() -> {
            List<CloudOfflinePlayer> players = this.offlinePlayers(name);
            return players.isEmpty() ? null : players.get(0);
        });
    }

    @Override
    @NonNull
    public List<CloudOfflinePlayer> offlinePlayers(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.database().find("name", name).stream().map(document -> document.toInstanceOf(CloudOfflinePlayer.class)).toList();
    }

    @Override
    @NonNull
    public List<CloudOfflinePlayer> registeredPlayers() {
        return this.database().entries().values().stream().map(doc -> doc.toInstanceOf(CloudOfflinePlayer.class)).filter(Objects::nonNull).toList();
    }

    @Override
    public void updateOfflinePlayer(@NonNull CloudOfflinePlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.pushOfflinePlayerCache(player.uniqueId(), player);
        this.database().insert(player.uniqueId().toString(), (Document)Document.newJsonDocument().appendTree(player));
        ChannelMessage.builder().targetAll().message("update_offline_cloud_player").channel("bridge_internal_player_channel").buffer(DataBuf.empty().writeObject(player)).build().send();
        this.eventManager.callEvent(new BridgeUpdateCloudOfflinePlayerEvent(player));
    }

    @Override
    public void updateOnlinePlayer(@NonNull CloudPlayer cloudPlayer) {
        if (cloudPlayer == null) {
            throw new NullPointerException("cloudPlayer is marked non-null but is null");
        }
        this.pushOnlinePlayerCache(cloudPlayer);
        ChannelMessage.builder().targetAll().message("update_online_cloud_player").channel("bridge_internal_player_channel").buffer(DataBuf.empty().writeObject(cloudPlayer)).build().send();
        this.eventManager.callEvent(new BridgeUpdateCloudPlayerEvent(cloudPlayer));
    }

    @Override
    public void deleteCloudOfflinePlayer(@NonNull CloudOfflinePlayer cloudOfflinePlayer) {
        if (cloudOfflinePlayer == null) {
            throw new NullPointerException("cloudOfflinePlayer is marked non-null but is null");
        }
        this.pushOfflinePlayerCache(cloudOfflinePlayer.uniqueId(), null);
        this.database().delete(cloudOfflinePlayer.uniqueId().toString());
        ChannelMessage.builder().targetAll().message("delete_offline_cloud_player").channel("bridge_internal_player_channel").buffer(DataBuf.empty().writeObject(cloudOfflinePlayer)).build().send();
        this.eventManager.callEvent(new BridgeDeleteCloudOfflinePlayerEvent(cloudOfflinePlayer));
    }

    @Override
    @NonNull
    public PlayerExecutor globalPlayerExecutor() {
        return NodePlayerExecutor.GLOBAL;
    }

    @Override
    @NonNull
    public PlayerExecutor playerExecutor(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return new NodePlayerExecutor(uniqueId, this);
    }

    public void pushOfflinePlayerCache(@NonNull UUID uniqueId, @Nullable CloudOfflinePlayer cloudOfflinePlayer) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        this.offlinePlayerCache.put(uniqueId, Optional.ofNullable(cloudOfflinePlayer));
    }

    public void pushOnlinePlayerCache(@NonNull CloudPlayer cloudPlayer) {
        if (cloudPlayer == null) {
            throw new NullPointerException("cloudPlayer is marked non-null but is null");
        }
        this.onlinePlayers.replace(cloudPlayer.uniqueId(), cloudPlayer);
        this.pushOfflinePlayerCache(cloudPlayer.uniqueId(), CloudOfflinePlayer.offlineCopy(cloudPlayer));
    }

    @NonNull
    protected LocalDatabase database() {
        return this.nodeDatabaseProvider.database(this.databaseName);
    }

    @NonNull
    public Map<UUID, CloudPlayer> players() {
        return this.onlinePlayers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loginPlayer(@NonNull NetworkPlayerProxyInfo networkPlayerProxyInfo, @Nullable NetworkServiceInfo joinedServiceInfo) {
        if (networkPlayerProxyInfo == null) {
            throw new NullPointerException("networkPlayerProxyInfo is marked non-null but is null");
        }
        Lock loginLock = this.playerReadWriteLocks.get(networkPlayerProxyInfo.uniqueId());
        try {
            loginLock.lock();
            this.loginPlayer0(networkPlayerProxyInfo, joinedServiceInfo);
        }
        finally {
            loginLock.unlock();
        }
    }

    protected void loginPlayer0(@NonNull NetworkPlayerProxyInfo networkPlayerProxyInfo, @Nullable NetworkServiceInfo joinedServiceInfo) {
        if (networkPlayerProxyInfo == null) {
            throw new NullPointerException("networkPlayerProxyInfo is marked non-null but is null");
        }
        NetworkServiceInfo networkService = networkPlayerProxyInfo.networkService();
        CloudPlayer cloudPlayer = this.selectPlayerForLogin(networkPlayerProxyInfo, joinedServiceInfo);
        cloudPlayer.loginService(networkService);
        cloudPlayer.connectedService(joinedServiceInfo);
        this.processLogin(cloudPlayer);
    }

    @NonNull
    protected CloudPlayer selectPlayerForLogin(@NonNull NetworkPlayerProxyInfo connectionInfo, @Nullable NetworkServiceInfo joinedServiceInfo) {
        if (connectionInfo == null) {
            throw new NullPointerException("connectionInfo is marked non-null but is null");
        }
        CloudPlayer cloudPlayer = this.onlinePlayer(connectionInfo.uniqueId());
        if (cloudPlayer == null) {
            for (CloudPlayer player : this.players().values()) {
                if (!player.name().equals(connectionInfo.name()) || !player.loginService().uniqueId().equals(connectionInfo.networkService().uniqueId())) continue;
                cloudPlayer = player;
                break;
            }
            if (cloudPlayer == null) {
                CloudOfflinePlayer cloudOfflinePlayer = this.getOrRegisterOfflinePlayer(connectionInfo);
                cloudPlayer = new CloudPlayer(connectionInfo, connectionInfo.networkService(), joinedServiceInfo == null ? connectionInfo.networkService() : joinedServiceInfo, null, Document.newJsonDocument(), connectionInfo.name(), cloudOfflinePlayer.firstLoginTimeMillis(), System.currentTimeMillis(), cloudOfflinePlayer.lastNetworkPlayerProxyInfo(), cloudOfflinePlayer.propertyHolder());
                this.onlinePlayers.put(cloudPlayer.uniqueId(), cloudPlayer);
            }
        }
        return cloudPlayer;
    }

    protected void processLogin(@NonNull CloudPlayer cloudPlayer) {
        if (cloudPlayer == null) {
            throw new NullPointerException("cloudPlayer is marked non-null but is null");
        }
        this.pushOnlinePlayerCache(cloudPlayer);
        this.database().insert(cloudPlayer.uniqueId().toString(), (Document)Document.newJsonDocument().appendTree(CloudOfflinePlayer.offlineCopy(cloudPlayer)));
        ChannelMessage.builder().targetAll().message("process_cloud_player_login").channel("bridge_internal_player_channel").buffer(DataBuf.empty().writeObject(cloudPlayer)).build().send();
        this.eventManager.callEvent(new BridgeProxyPlayerLoginEvent(cloudPlayer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLoginMessage(@NonNull CloudPlayer cloudPlayer) {
        if (cloudPlayer == null) {
            throw new NullPointerException("cloudPlayer is marked non-null but is null");
        }
        Lock loginLock = this.playerReadWriteLocks.get(cloudPlayer.uniqueId());
        try {
            loginLock.lock();
            CloudPlayer registeredPlayer = this.onlinePlayers.get(cloudPlayer.uniqueId());
            if (registeredPlayer == null) {
                this.onlinePlayers.put(cloudPlayer.uniqueId(), cloudPlayer);
                this.offlinePlayerCache.put(cloudPlayer.uniqueId(), Optional.of(cloudPlayer));
            } else {
                NetworkServiceInfo connectedService;
                NetworkServiceInfo loginService;
                boolean needsUpdate = false;
                NetworkServiceInfo newLoginService = cloudPlayer.loginService();
                if (!Objects.equals(newLoginService, loginService = registeredPlayer.loginService()) && ServiceEnvironmentType.minecraftProxy(newLoginService.environment()) && !ServiceEnvironmentType.minecraftProxy(loginService.environment())) {
                    cloudPlayer.loginService(newLoginService);
                    needsUpdate = true;
                }
                if (cloudPlayer.connectedService() != null && ServiceEnvironmentType.minecraftProxy(cloudPlayer.connectedService().environment()) && (connectedService = registeredPlayer.connectedService()) != null && ServiceEnvironmentType.minecraftServer(connectedService.environment())) {
                    cloudPlayer.connectedService(connectedService);
                    needsUpdate = true;
                }
                if (needsUpdate) {
                    this.onlinePlayers.replace(cloudPlayer.uniqueId(), cloudPlayer);
                }
            }
        }
        finally {
            loginLock.unlock();
        }
    }

    @NonNull
    public CloudOfflinePlayer getOrRegisterOfflinePlayer(@NonNull NetworkPlayerProxyInfo proxyInfo) {
        if (proxyInfo == null) {
            throw new NullPointerException("proxyInfo is marked non-null but is null");
        }
        CloudOfflinePlayer cloudOfflinePlayer = this.offlinePlayer(proxyInfo.uniqueId());
        if (cloudOfflinePlayer == null) {
            cloudOfflinePlayer = new CloudOfflinePlayer(proxyInfo.name(), System.currentTimeMillis(), System.currentTimeMillis(), proxyInfo, Document.newJsonDocument());
            this.offlinePlayerCache.put(proxyInfo.uniqueId(), Optional.of(cloudOfflinePlayer));
        }
        return cloudOfflinePlayer;
    }

    public void logoutPlayer(@NonNull CloudPlayer cloudPlayer) {
        if (cloudPlayer == null) {
            throw new NullPointerException("cloudPlayer is marked non-null but is null");
        }
        Lock managementLock = this.playerReadWriteLocks.get(cloudPlayer.uniqueId());
        try {
            managementLock.lock();
            this.logoutPlayer0(cloudPlayer);
        }
        finally {
            managementLock.unlock();
        }
    }

    private void logoutPlayer0(@NonNull CloudPlayer cloudPlayer) {
        if (cloudPlayer == null) {
            throw new NullPointerException("cloudPlayer is marked non-null but is null");
        }
        this.onlinePlayers.remove(cloudPlayer.uniqueId());
        cloudPlayer.lastNetworkPlayerProxyInfo(cloudPlayer.networkPlayerProxyInfo());
        CloudOfflinePlayer offlinePlayer = CloudOfflinePlayer.offlineCopy(cloudPlayer);
        this.pushOfflinePlayerCache(cloudPlayer.uniqueId(), offlinePlayer);
        this.database().insert(offlinePlayer.uniqueId().toString(), (Document)Document.newJsonDocument().appendTree(offlinePlayer));
        ChannelMessage.builder().targetAll().channel("bridge_internal_player_channel").message("process_cloud_player_logout").buffer(DataBuf.empty().writeObject(cloudPlayer)).build().send();
        this.eventManager.callEvent(new BridgeProxyPlayerDisconnectEvent(cloudPlayer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="!null, !null, _ -> _; !null, null, _ -> _; null, !null, _ -> _; null, null, _ -> fail")
    public void logoutPlayer(@Nullable UUID uniqueId, @Nullable String name, @Nullable Predicate<CloudPlayer> tester) {
        CloudPlayer cloudPlayer;
        Preconditions.checkArgument(uniqueId != null || name != null);
        if (uniqueId != null) {
            Lock managementLock = this.playerReadWriteLocks.get(uniqueId);
            try {
                managementLock.lock();
                cloudPlayer = this.onlinePlayer(uniqueId);
            }
            finally {
                managementLock.unlock();
            }
        } else {
            cloudPlayer = this.firstOnlinePlayer(name);
        }
        if (cloudPlayer != null && (tester == null || tester.test(cloudPlayer))) {
            this.logoutPlayer(cloudPlayer);
        }
    }
}

