/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.node.player;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.channel.ChannelMessage;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.service.ServiceEnvironmentType;
import eu.cloudnetservice.modules.bridge.player.CloudPlayer;
import eu.cloudnetservice.modules.bridge.player.PlayerManager;
import eu.cloudnetservice.modules.bridge.player.executor.PlayerExecutor;
import eu.cloudnetservice.modules.bridge.player.executor.ServerSelectorType;
import java.util.UUID;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class NodePlayerExecutor
implements PlayerExecutor {
    protected static final PlayerExecutor GLOBAL = new NodePlayerExecutor(GLOBAL_UNIQUE_ID);
    protected final UUID targetUniqueId;
    protected final PlayerManager playerManager;

    @ApiStatus.Internal
    protected NodePlayerExecutor(@NonNull UUID targetUniqueId) {
        if (targetUniqueId == null) {
            throw new NullPointerException("targetUniqueId is marked non-null but is null");
        }
        this.targetUniqueId = targetUniqueId;
        this.playerManager = null;
    }

    public NodePlayerExecutor(@NonNull UUID targetUniqueId, @NonNull PlayerManager playerManager) {
        if (targetUniqueId == null) {
            throw new NullPointerException("targetUniqueId is marked non-null but is null");
        }
        if (playerManager == null) {
            throw new NullPointerException("playerManager is marked non-null but is null");
        }
        this.targetUniqueId = targetUniqueId;
        this.playerManager = playerManager;
    }

    @Override
    @NonNull
    public UUID uniqueId() {
        return this.targetUniqueId;
    }

    @Override
    public void connect(@NonNull String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is marked non-null but is null");
        }
        this.toProxy().message("connect_to_service").buffer(DataBuf.empty().writeUniqueId(this.targetUniqueId).writeString(serviceName)).build().send();
    }

    @Override
    public void connectSelecting(@NonNull ServerSelectorType selectorType) {
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
        this.toProxy().message("connect_to_selector").buffer(DataBuf.empty().writeUniqueId(this.targetUniqueId).writeObject((Object)selectorType)).build().send();
    }

    @Override
    public void connectToFallback() {
        this.toProxy().message("connect_to_fallback").buffer(DataBuf.empty().writeUniqueId(this.targetUniqueId)).build().send();
    }

    @Override
    public void connectToGroup(@NonNull String group, @NonNull ServerSelectorType selectorType) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
        this.toProxy().message("connect_to_group").buffer(DataBuf.empty().writeUniqueId(this.targetUniqueId).writeString(group).writeObject((Object)selectorType)).build().send();
    }

    @Override
    public void connectToTask(@NonNull String task, @NonNull ServerSelectorType selectorType) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
        this.toProxy().message("connect_to_task").buffer(DataBuf.empty().writeUniqueId(this.targetUniqueId).writeString(task).writeObject((Object)selectorType)).build().send();
    }

    @Override
    public void kick(@NonNull Component message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.toProxy().message("kick_player").buffer(DataBuf.empty().writeUniqueId(this.targetUniqueId).writeObject(message)).build().send();
    }

    @Override
    public void sendTitle(@NonNull Title title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.toProxy().message("send_title").buffer(DataBuf.empty().writeUniqueId(this.targetUniqueId).writeObject(title)).build().send();
    }

    @Override
    public void sendChatMessage(@NonNull Component message, @Nullable String permission) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.toProxy().message("send_chat_message").buffer(DataBuf.empty().writeUniqueId(this.targetUniqueId).writeObject(message).writeNullable(permission, DataBuf.Mutable::writeString)).build().send();
    }

    @Override
    public void sendPluginMessage(@NonNull String key, byte[] data) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.toProxy().message("send_plugin_message").buffer(DataBuf.empty().writeUniqueId(this.targetUniqueId).writeString(key).writeByteArray(data)).build().send();
    }

    @Override
    public void spoofCommandExecution(@NonNull String command, boolean redirectToServer) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        this.toProxy().message("spoof_command_execution").buffer(DataBuf.empty().writeUniqueId(this.targetUniqueId).writeString(command).writeBoolean(redirectToServer)).build().send();
    }

    @NonNull
    protected ChannelMessage.Builder toProxy() {
        ChannelMessage.Builder message;
        if (this.targetUniqueId.equals(GLOBAL_UNIQUE_ID)) {
            message = ChannelMessage.builder().targetEnvironment(ServiceEnvironmentType.VELOCITY).targetEnvironment(ServiceEnvironmentType.BUNGEECORD).targetEnvironment(ServiceEnvironmentType.WATERDOG_PE);
        } else {
            CloudPlayer player = this.playerManager.onlinePlayer(this.targetUniqueId);
            Preconditions.checkNotNull(player, "Target player %s is not connected (anymore)", (Object)this.targetUniqueId);
            message = ChannelMessage.builder().targetService(player.loginService().serverName());
        }
        return message.channel("bridge_internal_player_executor_channel");
    }
}

