/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.node.network;

import eu.cloudnetservice.driver.channel.ChannelMessage;
import eu.cloudnetservice.driver.event.EventListener;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.event.events.channel.ChannelMessageReceiveEvent;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.ext.component.ComponentFormats;
import eu.cloudnetservice.modules.bridge.BridgeManagement;
import eu.cloudnetservice.modules.bridge.event.BridgeDeleteCloudOfflinePlayerEvent;
import eu.cloudnetservice.modules.bridge.event.BridgeProxyPlayerDisconnectEvent;
import eu.cloudnetservice.modules.bridge.event.BridgeProxyPlayerLoginEvent;
import eu.cloudnetservice.modules.bridge.event.BridgeProxyPlayerServerSwitchEvent;
import eu.cloudnetservice.modules.bridge.event.BridgeServerPlayerDisconnectEvent;
import eu.cloudnetservice.modules.bridge.event.BridgeServerPlayerLoginEvent;
import eu.cloudnetservice.modules.bridge.event.BridgeUpdateCloudOfflinePlayerEvent;
import eu.cloudnetservice.modules.bridge.event.BridgeUpdateCloudPlayerEvent;
import eu.cloudnetservice.modules.bridge.node.event.LocalPlayerPreLoginEvent;
import eu.cloudnetservice.modules.bridge.node.player.NodePlayerManager;
import eu.cloudnetservice.modules.bridge.player.CloudOfflinePlayer;
import eu.cloudnetservice.modules.bridge.player.CloudPlayer;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerProxyInfo;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerServerInfo;
import eu.cloudnetservice.modules.bridge.player.NetworkServiceInfo;
import jakarta.inject.Singleton;
import java.util.Locale;
import java.util.UUID;
import lombok.NonNull;
import net.kyori.adventure.text.Component;

@Singleton
public final class NodePlayerChannelMessageListener {
    @EventListener
    public void handle(@NonNull ChannelMessageReceiveEvent event, @NonNull EventManager eventManager, @NonNull NodePlayerManager playerManager, @NonNull BridgeManagement bridgeManagement) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (playerManager == null) {
            throw new NullPointerException("playerManager is marked non-null but is null");
        }
        if (bridgeManagement == null) {
            throw new NullPointerException("bridgeManagement is marked non-null but is null");
        }
        if (event.channel().equals("bridge_internal_player_channel")) {
            switch (event.message()) {
                case "proxy_player_pre_login": {
                    NetworkPlayerProxyInfo info = event.content().readObject(NetworkPlayerProxyInfo.class);
                    LocalPlayerPreLoginEvent preLoginEvent = new LocalPlayerPreLoginEvent(info);
                    if (playerManager.onlinePlayer(info.uniqueId()) != null) {
                        preLoginEvent.result(bridgeManagement.configuration().findMessage(Locale.ENGLISH, "already-connected", message -> {
                            Component component = ComponentFormats.BUNGEE_TO_ADVENTURE.convert((String)message);
                            return LocalPlayerPreLoginEvent.Result.denied(component);
                        }, LocalPlayerPreLoginEvent.Result.denied(Component.empty()), true));
                    }
                    LocalPlayerPreLoginEvent.Result result = eventManager.callEvent(preLoginEvent).result();
                    event.binaryResponse(DataBuf.empty().writeObject(result));
                    break;
                }
                case "update_offline_cloud_player": {
                    CloudOfflinePlayer player = event.content().readObject(CloudOfflinePlayer.class);
                    playerManager.pushOfflinePlayerCache(player.uniqueId(), player);
                    eventManager.callEvent(new BridgeUpdateCloudOfflinePlayerEvent(player));
                    break;
                }
                case "update_online_cloud_player": {
                    CloudPlayer player = event.content().readObject(CloudPlayer.class);
                    playerManager.pushOnlinePlayerCache(player);
                    eventManager.callEvent(new BridgeUpdateCloudPlayerEvent(player));
                    break;
                }
                case "delete_offline_cloud_player": {
                    CloudOfflinePlayer player = event.content().readObject(CloudOfflinePlayer.class);
                    playerManager.pushOfflinePlayerCache(player.uniqueId(), null);
                    eventManager.callEvent(new BridgeDeleteCloudOfflinePlayerEvent(player));
                    break;
                }
                case "process_cloud_player_login": {
                    CloudPlayer player = event.content().readObject(CloudPlayer.class);
                    playerManager.processLoginMessage(player);
                    eventManager.callEvent(new BridgeProxyPlayerLoginEvent(player));
                    break;
                }
                case "process_cloud_player_logout": {
                    CloudPlayer player = event.content().readObject(CloudPlayer.class);
                    playerManager.players().remove(player.uniqueId());
                    playerManager.pushOfflinePlayerCache(player.uniqueId(), CloudOfflinePlayer.offlineCopy(player));
                    eventManager.callEvent(new BridgeProxyPlayerDisconnectEvent(player));
                    break;
                }
                case "proxy_player_login": {
                    NetworkPlayerProxyInfo proxy = event.content().readObject(NetworkPlayerProxyInfo.class);
                    NetworkServiceInfo joinedService = event.content().readObject(NetworkServiceInfo.class);
                    playerManager.loginPlayer(proxy, joinedService);
                    break;
                }
                case "proxy_player_service_switch": {
                    UUID uniqueId = event.content().readUniqueId();
                    NetworkServiceInfo target = event.content().readObject(NetworkServiceInfo.class);
                    CloudPlayer player = playerManager.onlinePlayer(uniqueId);
                    if (player == null) break;
                    NetworkServiceInfo prev = player.connectedService();
                    player.connectedService(target);
                    eventManager.callEvent(new BridgeProxyPlayerServerSwitchEvent(player, prev));
                    ChannelMessage.builder().targetAll().message("cloud_player_service_switch").channel("bridge_internal_player_channel").buffer(DataBuf.empty().writeObject(player).writeObject(prev)).build().send();
                    break;
                }
                case "cloud_player_service_switch": {
                    CloudPlayer player = event.content().readObject(CloudPlayer.class);
                    NetworkServiceInfo previous = event.content().readObject(NetworkServiceInfo.class);
                    playerManager.pushOnlinePlayerCache(player);
                    eventManager.callEvent(new BridgeProxyPlayerServerSwitchEvent(player, previous));
                    break;
                }
                case "proxy_player_disconnect": {
                    UUID uniqueId = event.content().readUniqueId();
                    playerManager.logoutPlayer(uniqueId, null, null);
                    break;
                }
                case "server_player_login": {
                    UUID playerUniqueId = event.content().readUniqueId();
                    NetworkPlayerServerInfo info = event.content().readObject(NetworkPlayerServerInfo.class);
                    CloudPlayer player = playerManager.onlinePlayer(playerUniqueId);
                    if (player == null) break;
                    player.networkPlayerServerInfo(info);
                    eventManager.callEvent(new BridgeServerPlayerLoginEvent(player, info));
                    ChannelMessage.builder().targetAll().message("cloud_player_server_login").channel("bridge_internal_player_channel").buffer(DataBuf.empty().writeObject(player).writeObject(info)).build().send();
                    break;
                }
                case "server_player_disconnect": {
                    UUID playerUniqueId = event.content().readUniqueId();
                    NetworkServiceInfo info = event.content().readObject(NetworkServiceInfo.class);
                    CloudPlayer player = playerManager.onlinePlayer(playerUniqueId);
                    if (player == null) break;
                    eventManager.callEvent(new BridgeServerPlayerDisconnectEvent(player, info));
                    ChannelMessage.builder().targetAll().message("cloud_player_server_disconnect").channel("bridge_internal_player_channel").buffer(DataBuf.empty().writeObject(player).writeObject(info)).build().send();
                    break;
                }
                case "cloud_player_server_login": {
                    CloudPlayer player = event.content().readObject(CloudPlayer.class);
                    NetworkPlayerServerInfo serviceInfo = event.content().readObject(NetworkPlayerServerInfo.class);
                    playerManager.pushOnlinePlayerCache(player);
                    eventManager.callEvent(new BridgeServerPlayerLoginEvent(player, serviceInfo));
                    break;
                }
                case "cloud_player_server_disconnect": {
                    CloudPlayer player = event.content().readObject(CloudPlayer.class);
                    NetworkServiceInfo serviceInfo = event.content().readObject(NetworkServiceInfo.class);
                    eventManager.callEvent(new BridgeServerPlayerDisconnectEvent(player, serviceInfo));
                    break;
                }
            }
        }
    }
}

