/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.node.network;

import eu.cloudnetservice.driver.event.EventListener;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.event.events.channel.ChannelMessageReceiveEvent;
import eu.cloudnetservice.modules.bridge.config.BridgeConfiguration;
import eu.cloudnetservice.modules.bridge.event.BridgeConfigurationUpdateEvent;
import eu.cloudnetservice.modules.bridge.node.NodeBridgeManagement;
import jakarta.inject.Singleton;
import lombok.NonNull;

@Singleton
public final class NodeBridgeChannelMessageListener {
    @EventListener
    public void handle(@NonNull ChannelMessageReceiveEvent event, @NonNull EventManager eventManager, @NonNull NodeBridgeManagement management) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (management == null) {
            throw new NullPointerException("management is marked non-null but is null");
        }
        if (event.channel().equals("bridge_internal_com_channel") && event.message().equals("update_bridge_configuration")) {
            BridgeConfiguration configuration = event.content().readObject(BridgeConfiguration.class);
            management.configurationSilently(configuration);
            eventManager.callEvent(new BridgeConfigurationUpdateEvent(configuration));
        }
    }
}

