/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.node.listener;

import eu.cloudnetservice.common.Named;
import eu.cloudnetservice.driver.event.EventListener;
import eu.cloudnetservice.driver.provider.ServiceTaskProvider;
import eu.cloudnetservice.driver.service.ServiceEnvironmentType;
import eu.cloudnetservice.modules.bridge.BridgeManagement;
import eu.cloudnetservice.modules.bridge.config.BridgeConfiguration;
import eu.cloudnetservice.modules.bridge.config.ProxyFallbackConfiguration;
import eu.cloudnetservice.node.console.animation.setup.answer.Parsers;
import eu.cloudnetservice.node.console.animation.setup.answer.QuestionAnswerType;
import eu.cloudnetservice.node.console.animation.setup.answer.QuestionListEntry;
import eu.cloudnetservice.node.event.setup.SetupCompleteEvent;
import eu.cloudnetservice.node.event.setup.SetupInitiateEvent;
import eu.cloudnetservice.node.version.ServiceVersionProvider;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.stream.Collectors;
import lombok.NonNull;

@Singleton
public final class NodeSetupListener {
    private final QuestionListEntry<String> bridgeFallbackQuestionEntry;

    @Inject
    public NodeSetupListener(@NonNull ServiceTaskProvider taskProvider, @NonNull ServiceVersionProvider versionProvider) {
        if (taskProvider == null) {
            throw new NullPointerException("taskProvider is marked non-null but is null");
        }
        if (versionProvider == null) {
            throw new NullPointerException("versionProvider is marked non-null but is null");
        }
        this.bridgeFallbackQuestionEntry = this.createBridgeFallbackEntry(taskProvider, versionProvider);
    }

    @EventListener
    public void handleSetupInitialize(@NonNull SetupInitiateEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        event.setup().entries().stream().filter(entry -> entry.key().equals("taskEnvironment")).findFirst().ifPresent(entry -> entry.answerType().thenAccept(($2, env) -> {
            if (!event.setup().hasResult("generateBridgeFallback") && ServiceEnvironmentType.minecraftProxy((ServiceEnvironmentType)env)) {
                event.setup().addEntries(new QuestionListEntry[]{this.bridgeFallbackQuestionEntry});
            }
        }));
    }

    @EventListener
    public void handleSetupComplete(@NonNull SetupCompleteEvent event, @NonNull BridgeManagement bridgeManagement) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (bridgeManagement == null) {
            throw new NullPointerException("bridgeManagement is marked non-null but is null");
        }
        String fallbackName = (String)event.setup().result("generateBridgeFallback");
        if (fallbackName != null && !fallbackName.isEmpty() && !fallbackName.equalsIgnoreCase("none")) {
            BridgeConfiguration config = bridgeManagement.configuration();
            config.fallbackConfigurations().add(ProxyFallbackConfiguration.builder().targetGroup((String)event.setup().result("taskName")).defaultFallbackTask(fallbackName).build());
            bridgeManagement.configuration(config);
        }
    }

    @NonNull
    private QuestionListEntry<String> createBridgeFallbackEntry(@NonNull ServiceTaskProvider taskProvider, @NonNull ServiceVersionProvider versionProvider) {
        if (taskProvider == null) {
            throw new NullPointerException("taskProvider is marked non-null but is null");
        }
        if (versionProvider == null) {
            throw new NullPointerException("versionProvider is marked non-null but is null");
        }
        return QuestionListEntry.builder().key("generateBridgeFallback").translatedQuestion("module-bridge-tasks-setup-default-fallback", new Object[0]).answerType(QuestionAnswerType.builder().parser(input -> {
            if (input.equalsIgnoreCase("none") || taskProvider.serviceTask(input) != null) {
                return input;
            }
            throw Parsers.ParserException.INSTANCE;
        }).possibleResults(this.possibleFallbackTasks(taskProvider, versionProvider))).build();
    }

    @NonNull
    private Collection<String> possibleFallbackTasks(@NonNull ServiceTaskProvider taskProvider, @NonNull ServiceVersionProvider versionProvider) {
        if (taskProvider == null) {
            throw new NullPointerException("taskProvider is marked non-null but is null");
        }
        if (versionProvider == null) {
            throw new NullPointerException("versionProvider is marked non-null but is null");
        }
        return taskProvider.serviceTasks().stream().filter(task -> {
            ServiceEnvironmentType env = versionProvider.environmentType(task.processConfiguration().environment());
            return env != null && ServiceEnvironmentType.minecraftServer(env);
        }).map(Named::name).collect(Collectors.collectingAndThen(Collectors.toList(), results -> {
            results.add("none");
            return results;
        }));
    }
}

