/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.node.listener;

import com.google.common.collect.Iterables;
import eu.cloudnetservice.driver.ComponentInfo;
import eu.cloudnetservice.driver.event.EventListener;
import eu.cloudnetservice.driver.event.events.service.CloudServiceLifecycleChangeEvent;
import eu.cloudnetservice.driver.event.events.service.CloudServiceUpdateEvent;
import eu.cloudnetservice.driver.service.ServiceEnvironmentType;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import eu.cloudnetservice.driver.service.ServiceLifeCycle;
import eu.cloudnetservice.modules.bridge.BridgeDocProperties;
import eu.cloudnetservice.modules.bridge.node.player.NodePlayerManager;
import eu.cloudnetservice.modules.bridge.player.CloudPlayer;
import eu.cloudnetservice.modules.bridge.player.ServicePlayer;
import eu.cloudnetservice.node.event.service.CloudServicePostLifecycleEvent;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import lombok.NonNull;

@Singleton
public final class BridgeLocalProxyPlayerDisconnectListener {
    private final NodePlayerManager playerManager;

    @Inject
    public BridgeLocalProxyPlayerDisconnectListener(@NonNull NodePlayerManager playerManager) {
        if (playerManager == null) {
            throw new NullPointerException("playerManager is marked non-null but is null");
        }
        this.playerManager = playerManager;
    }

    @EventListener
    public void handleServiceUpdate(@NonNull CloudServiceUpdateEvent event, @NonNull ComponentInfo componentInfo) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (componentInfo == null) {
            throw new NullPointerException("componentInfo is marked non-null but is null");
        }
        ServiceInfoSnapshot info = event.serviceInfo();
        if (info.serviceId().nodeUniqueId().equals(componentInfo.componentName()) && ServiceEnvironmentType.minecraftProxy(info.serviceId().environment())) {
            Collection<ServicePlayer> players = info.readProperty(BridgeDocProperties.PLAYERS);
            if (players == null) {
                return;
            }
            for (CloudPlayer value : this.playerManager.players().values()) {
                ServicePlayer match;
                if (!value.loginService().serviceId().uniqueId().equals(info.serviceId().uniqueId()) || (match = Iterables.tryFind(players, player -> player.uniqueId().equals(value.uniqueId())).orNull()) != null) continue;
                this.playerManager.logoutPlayer(value);
            }
        }
    }

    @EventListener
    public void handleLocalServiceLifecycleChange(@NonNull CloudServicePostLifecycleEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (event.newLifeCycle() == ServiceLifeCycle.STOPPED || event.newLifeCycle() == ServiceLifeCycle.DELETED) {
            this.handleCloudServiceRemove(event.serviceInfo());
        }
    }

    @EventListener
    public void handleClusterServiceLifecycleChange(@NonNull CloudServiceLifecycleChangeEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (event.newLifeCycle() == ServiceLifeCycle.STOPPED || event.newLifeCycle() == ServiceLifeCycle.DELETED) {
            this.handleCloudServiceRemove(event.serviceInfo());
        }
    }

    private void handleCloudServiceRemove(@NonNull ServiceInfoSnapshot snapshot) {
        if (snapshot == null) {
            throw new NullPointerException("snapshot is marked non-null but is null");
        }
        if (ServiceEnvironmentType.minecraftProxy(snapshot.serviceId().environment())) {
            for (CloudPlayer value : this.playerManager.players().values()) {
                if (!value.loginService().serviceId().uniqueId().equals(snapshot.serviceId().uniqueId())) continue;
                this.playerManager.logoutPlayer(value);
            }
        }
    }
}

