/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.node.event;

import eu.cloudnetservice.driver.event.Event;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerProxyInfo;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public final class LocalPlayerPreLoginEvent
extends Event {
    private final NetworkPlayerProxyInfo playerInfo;
    private Result result = Result.allowed();

    public LocalPlayerPreLoginEvent(@NonNull NetworkPlayerProxyInfo playerInfo) {
        if (playerInfo == null) {
            throw new NullPointerException("playerInfo is marked non-null but is null");
        }
        this.playerInfo = playerInfo;
    }

    @NonNull
    public NetworkPlayerProxyInfo playerInfo() {
        return this.playerInfo;
    }

    @NonNull
    public Result result() {
        return this.result;
    }

    public void result(@NonNull Result result) {
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        this.result = result;
    }

    public static final class Result {
        private static final Result ALLOWED = new Result(true, null);
        private final boolean allowed;
        private final Component result;

        private Result(boolean allowed, @Nullable Component result) {
            this.allowed = allowed;
            this.result = result;
        }

        @NonNull
        public static Result allowed() {
            return ALLOWED;
        }

        @NonNull
        public static Result denied(@Nullable Component reason) {
            return new Result(false, reason);
        }

        public boolean permitLogin() {
            return this.allowed;
        }

        public @UnknownNullability Component result() {
            return this.result;
        }
    }
}

