/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.node.command;

import eu.cloudnetservice.common.Named;
import eu.cloudnetservice.common.language.I18n;
import eu.cloudnetservice.driver.provider.CloudServiceProvider;
import eu.cloudnetservice.driver.service.ServiceEnvironmentType;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import eu.cloudnetservice.ext.component.ComponentFormats;
import eu.cloudnetservice.modules.bridge.BridgeDocProperties;
import eu.cloudnetservice.modules.bridge.node.player.NodePlayerManager;
import eu.cloudnetservice.modules.bridge.player.CloudOfflinePlayer;
import eu.cloudnetservice.modules.bridge.player.CloudPlayer;
import eu.cloudnetservice.modules.bridge.player.executor.PlayerExecutor;
import eu.cloudnetservice.node.command.annotation.CommandAlias;
import eu.cloudnetservice.node.command.annotation.Description;
import eu.cloudnetservice.node.command.exception.ArgumentNotAvailableException;
import eu.cloudnetservice.node.command.source.CommandSource;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import java.util.stream.Stream;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.incendo.cloud.annotation.specifier.Greedy;
import org.incendo.cloud.annotation.specifier.Quoted;
import org.incendo.cloud.annotations.Argument;
import org.incendo.cloud.annotations.Command;
import org.incendo.cloud.annotations.Flag;
import org.incendo.cloud.annotations.Permission;
import org.incendo.cloud.annotations.parser.Parser;
import org.incendo.cloud.annotations.suggestion.Suggestions;
import org.incendo.cloud.context.CommandInput;
import org.jetbrains.annotations.Nullable;

@Singleton
@CommandAlias(value={"pl", "player"})
@Permission(value={"cloudnet.command.players"})
@Description(value="module-bridge-player-command-description")
public class PlayersCommand {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
    private final NodePlayerManager playerManager;
    private final CloudServiceProvider serviceProvider;

    @Inject
    public PlayersCommand(@NonNull NodePlayerManager playerManager, @NonNull CloudServiceProvider serviceProvider) {
        if (playerManager == null) {
            throw new NullPointerException("playerManager is marked non-null but is null");
        }
        if (serviceProvider == null) {
            throw new NullPointerException("serviceProvider is marked non-null but is null");
        }
        this.playerManager = playerManager;
        this.serviceProvider = serviceProvider;
    }

    @Parser(suggestions="onlinePlayers")
    @NonNull
    public CloudPlayer defaultCloudPlayerParser(@NonNull CommandInput input) {
        CloudPlayer player;
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        String identifier = input.readString();
        try {
            UUID uniqueId = UUID.fromString(identifier);
            player = this.playerManager.onlinePlayer(uniqueId);
        }
        catch (IllegalArgumentException exception) {
            player = this.playerManager.firstOnlinePlayer(identifier);
        }
        if (player == null) {
            throw new ArgumentNotAvailableException(I18n.trans("module-bridge-command-players-player-not-online", new Object[0]));
        }
        return player;
    }

    @Suggestions(value="onlinePlayers")
    @NonNull
    public Stream<String> suggestOnlinePlayers() {
        return this.playerManager.players().values().stream().map(Named::name);
    }

    @Parser(suggestions="playerService")
    @NonNull
    public ServiceInfoSnapshot playerServiceParser(@NonNull CommandInput input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        String name = input.readString();
        ServiceInfoSnapshot serviceInfoSnapshot = this.serviceProvider.serviceByName(name);
        if (serviceInfoSnapshot == null) {
            throw new ArgumentNotAvailableException(I18n.trans("command-service-service-not-found", new Object[0]));
        }
        return serviceInfoSnapshot;
    }

    @Suggestions(value="playerService")
    @NonNull
    public Stream<String> suggestPlayerService() {
        return this.serviceProvider.services().stream().filter(snapshot -> ServiceEnvironmentType.minecraftServer(snapshot.serviceId().environment())).map(Named::name);
    }

    @Parser(name="offlinePlayer")
    @NonNull
    public CloudOfflinePlayer defaultCloudOfflinePlayerParser(@NonNull CommandInput input) {
        CloudOfflinePlayer player;
        block5: {
            if (input == null) {
                throw new NullPointerException("input is marked non-null but is null");
            }
            String identifier = input.readString();
            try {
                UUID uniqueId = UUID.fromString(identifier);
                player = this.playerManager.onlinePlayer(uniqueId);
                if (player == null) {
                    player = this.playerManager.offlinePlayer(uniqueId);
                }
            }
            catch (IllegalArgumentException exception) {
                player = this.playerManager.firstOnlinePlayer(identifier);
                if (player != null) break block5;
                player = this.playerManager.firstOfflinePlayer(identifier);
            }
        }
        if (player == null) {
            throw new ArgumentNotAvailableException(I18n.trans("module-bridge-command-players-player-not-registered", new Object[0]));
        }
        return player;
    }

    @Command(value="players|player|pl online")
    public void displayOnlinePlayers(@NonNull CommandSource source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        for (CloudPlayer player : this.playerManager.players().values()) {
            source.sendMessage("Name: " + player.name() + " | UUID: " + String.valueOf(player.uniqueId()) + " | Proxy: " + player.loginService().serverName() + " | Service: " + player.connectedService().serverName());
        }
        source.sendMessage("=> Online players " + this.playerManager.onlineCount());
    }

    @Command(value="players|player|pl registered")
    public void displayRegisteredCount(@NonNull CommandSource source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        source.sendMessage("=> Registered players " + this.playerManager.registeredCount());
    }

    @Command(value="players|player|pl player <player>")
    public void displayPlayerInformation(@NonNull CommandSource source, @Argument(value="player", parserName="offlinePlayer") @NonNull CloudOfflinePlayer offlinePlayer) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (offlinePlayer == null) {
            throw new NullPointerException("offlinePlayer is marked non-null but is null");
        }
        ZonedDateTime firstLoginTime = Instant.ofEpochMilli(offlinePlayer.firstLoginTimeMillis()).atZone(ZoneId.systemDefault());
        ZonedDateTime lastLoginTime = Instant.ofEpochMilli(offlinePlayer.lastLoginTimeMillis()).atZone(ZoneId.systemDefault());
        source.sendMessage("CloudPlayer: " + offlinePlayer.name() + " | " + String.valueOf(offlinePlayer.uniqueId()));
        source.sendMessage("First login: " + DATE_TIME_FORMATTER.format(firstLoginTime));
        source.sendMessage("Last login: " + DATE_TIME_FORMATTER.format(lastLoginTime));
        if (offlinePlayer instanceof CloudPlayer) {
            CloudPlayer onlinePlayer = (CloudPlayer)offlinePlayer;
            source.sendMessage("Proxy: " + onlinePlayer.loginService().serverName());
            source.sendMessage("Service: " + onlinePlayer.connectedService().serverName());
            source.sendMessage("Online Properties: ");
            String[] stringArray = onlinePlayer.onlineProperties().serializeToString().split("\n");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String line = stringArray[i];
                source.sendMessage(line);
            }
        }
        for (String line : offlinePlayer.propertyHolder().serializeToString().split("\n")) {
            source.sendMessage(line);
        }
    }

    @Command(value="players|player|pl player <player> delete")
    public void deletePlayer(@NonNull CommandSource source, @Argument(value="player", parserName="offlinePlayer") @NonNull CloudOfflinePlayer player) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.playerManager.deleteCloudOfflinePlayer(player);
        source.sendMessage(I18n.trans("module-bridge-command-players-delete-player", player.name(), player.uniqueId()));
    }

    @Command(value="players|player|pl online <player> kick [reason]")
    public void kickPlayer(@NonNull CommandSource source, @Argument(value="player") @NonNull CloudPlayer player, @Quoted @Argument(value="reason") @Nullable String reason, @Flag(value="force") boolean force) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        TextComponent reasonComponent = reason == null ? Component.empty() : ComponentFormats.BUNGEE_TO_ADVENTURE.convert(reason);
        this.playerExecutor(player).kick(reasonComponent);
        source.sendMessage(I18n.trans("module-bridge-command-players-kick-player", player.name(), player.uniqueId(), reason == null ? "No reason given" : reason));
        if (force) {
            this.playerManager.logoutPlayer(player);
            source.sendMessage(I18n.trans("module-bridge-command-players-kick-player-force", new Object[0]));
        }
    }

    @Command(value="players|player|pl online <player> message <message>")
    public void messagePlayer(@NonNull CommandSource source, @Argument(value="player") @NonNull CloudPlayer player, @Greedy @Argument(value="message") @NonNull String message) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.playerExecutor(player).sendChatMessage(ComponentFormats.BUNGEE_TO_ADVENTURE.convert(message));
        source.sendMessage(I18n.trans("module-bridge-command-players-send-player-message", player.name(), player.uniqueId()));
    }

    @Command(value="players|player|pl online <player> connect <server>")
    public void connectPlayer(@NonNull CommandSource source, @Argument(value="player") @NonNull CloudPlayer player, @Argument(value="server") @NonNull ServiceInfoSnapshot server) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        if (server.readProperty(BridgeDocProperties.IS_ONLINE).booleanValue()) {
            this.playerExecutor(player).connect(server.name());
            source.sendMessage(I18n.trans("module-bridge-command-players-send-player-server", player.name(), player.uniqueId()));
        } else {
            source.sendMessage(I18n.trans("module-bridge-command-players-send-player-server-not-found", player.name(), player.uniqueId()));
        }
    }

    @NonNull
    private PlayerExecutor playerExecutor(@NonNull CloudPlayer cloudPlayer) {
        if (cloudPlayer == null) {
            throw new NullPointerException("cloudPlayer is marked non-null but is null");
        }
        return this.playerManager.playerExecutor(cloudPlayer.uniqueId());
    }
}

