/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.node.command;

import eu.cloudnetservice.common.Named;
import eu.cloudnetservice.common.language.I18n;
import eu.cloudnetservice.driver.provider.GroupConfigurationProvider;
import eu.cloudnetservice.driver.provider.ServiceTaskProvider;
import eu.cloudnetservice.driver.service.GroupConfiguration;
import eu.cloudnetservice.driver.service.ServiceTask;
import eu.cloudnetservice.modules.bridge.BridgeManagement;
import eu.cloudnetservice.modules.bridge.config.BridgeConfiguration;
import eu.cloudnetservice.modules.bridge.config.ProxyFallbackConfiguration;
import eu.cloudnetservice.node.command.annotation.Description;
import eu.cloudnetservice.node.command.exception.ArgumentNotAvailableException;
import eu.cloudnetservice.node.command.source.CommandSource;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import lombok.NonNull;
import org.incendo.cloud.annotations.Argument;
import org.incendo.cloud.annotations.Command;
import org.incendo.cloud.annotations.Permission;
import org.incendo.cloud.annotations.parser.Parser;
import org.incendo.cloud.annotations.suggestion.Suggestions;
import org.incendo.cloud.context.CommandInput;

@Singleton
@Permission(value={"cloudnet.command.bridge"})
@Description(value="module-bridge-command-description")
public class BridgeCommand {
    private final ServiceTaskProvider taskProvider;
    private final BridgeManagement bridgeManagement;
    private final GroupConfigurationProvider groupConfigurationProvider;

    @Inject
    public BridgeCommand(@NonNull ServiceTaskProvider taskProvider, @NonNull BridgeManagement bridgeManagement, @NonNull GroupConfigurationProvider groupConfigurationProvider) {
        if (taskProvider == null) {
            throw new NullPointerException("taskProvider is marked non-null but is null");
        }
        if (bridgeManagement == null) {
            throw new NullPointerException("bridgeManagement is marked non-null but is null");
        }
        if (groupConfigurationProvider == null) {
            throw new NullPointerException("groupConfigurationProvider is marked non-null but is null");
        }
        this.taskProvider = taskProvider;
        this.bridgeManagement = bridgeManagement;
        this.groupConfigurationProvider = groupConfigurationProvider;
    }

    @Parser(name="bridgeGroups", suggestions="bridgeGroups")
    public GroupConfiguration bridgeGroupParser(@NonNull CommandInput input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        String name = input.readString();
        GroupConfiguration group = this.groupConfigurationProvider.groupConfiguration(name);
        if (group == null) {
            throw new ArgumentNotAvailableException(I18n.trans("command-general-group-does-not-exist", new Object[0]));
        }
        Stream<ProxyFallbackConfiguration> fallbacks = this.bridgeManagement.configuration().fallbackConfigurations().stream();
        if (fallbacks.anyMatch(fallback -> fallback.targetGroup().equals(group.name()))) {
            throw new ArgumentNotAvailableException(I18n.trans("module-bridge-command-entry-already-exists", new Object[0]));
        }
        return group;
    }

    @Suggestions(value="bridgeGroups")
    public Stream<String> suggestBridgeGroups() {
        return this.groupConfigurationProvider.groupConfigurations().stream().map(Named::name).filter(group -> this.bridgeManagement.configuration().fallbackConfigurations().stream().noneMatch(fallback -> fallback.targetGroup().equals(group)));
    }

    @Command(value="bridge create entry <targetGroup>")
    public void createBridgeEntry(@NonNull CommandSource source, @Argument(value="targetGroup", parserName="bridgeGroups") @NonNull GroupConfiguration group) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        ProxyFallbackConfiguration fallbackConfiguration = new ProxyFallbackConfiguration(group.name(), "Lobby", Collections.emptyList());
        BridgeConfiguration configuration = this.bridgeManagement.configuration();
        configuration.fallbackConfigurations().add(fallbackConfiguration);
        this.bridgeManagement.configuration(configuration);
        source.sendMessage(I18n.trans("module-bridge-command-create-entry-success", new Object[0]));
    }

    @Command(value="bridge task <task> set requiredPermission <permission>")
    public void setRequiredPermission(@NonNull CommandSource source, @Argument(value="task") @NonNull Collection<ServiceTask> serviceTasks, @Argument(value="permission") @NonNull String permission) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (serviceTasks == null) {
            throw new NullPointerException("serviceTasks is marked non-null but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        for (ServiceTask task : serviceTasks) {
            this.taskProvider.addServiceTask(((ServiceTask.Builder)ServiceTask.builder(task).modifyProperties(properties -> properties.append("requiredPermission", permission))).build());
            source.sendMessage(I18n.trans("command-tasks-set-property-success", "requiredPermission", task.name(), permission));
        }
    }
}

