/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.node;

import dev.derklaro.aerogel.PostConstruct;
import dev.derklaro.aerogel.auto.Provides;
import eu.cloudnetservice.driver.channel.ChannelMessage;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.rpc.factory.RPCFactory;
import eu.cloudnetservice.driver.network.rpc.handler.RPCHandler;
import eu.cloudnetservice.driver.network.rpc.handler.RPCHandlerRegistry;
import eu.cloudnetservice.driver.provider.ServiceTaskProvider;
import eu.cloudnetservice.driver.registry.ServiceRegistry;
import eu.cloudnetservice.driver.service.ServiceTask;
import eu.cloudnetservice.driver.util.ModuleHelper;
import eu.cloudnetservice.modules.bridge.BridgeDocProperties;
import eu.cloudnetservice.modules.bridge.BridgeManagement;
import eu.cloudnetservice.modules.bridge.config.BridgeConfiguration;
import eu.cloudnetservice.modules.bridge.event.BridgeConfigurationUpdateEvent;
import eu.cloudnetservice.modules.bridge.node.CloudNetBridgeModule;
import eu.cloudnetservice.modules.bridge.node.listener.NodeSetupListener;
import eu.cloudnetservice.modules.bridge.node.network.NodeBridgeChannelMessageListener;
import eu.cloudnetservice.modules.bridge.player.PlayerManager;
import eu.cloudnetservice.node.module.listener.PluginIncludeListener;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collections;
import lombok.NonNull;

@Singleton
@Provides(value={BridgeManagement.class})
public class NodeBridgeManagement
implements BridgeManagement {
    private final EventManager eventManager;
    private final PlayerManager playerManager;
    private final ServiceTaskProvider taskProvider;
    private final CloudNetBridgeModule bridgeModule;
    private BridgeConfiguration configuration;

    @Inject
    public NodeBridgeManagement(@NonNull ModuleHelper moduleHelper, @NonNull EventManager eventManager, @NonNull RPCFactory providerFactory, @NonNull PlayerManager playerManager, @NonNull ServiceTaskProvider taskProvider, @NonNull CloudNetBridgeModule bridgeModule, @NonNull BridgeConfiguration configuration, @NonNull RPCHandlerRegistry rpcHandlerRegistry) {
        if (moduleHelper == null) {
            throw new NullPointerException("moduleHelper is marked non-null but is null");
        }
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (providerFactory == null) {
            throw new NullPointerException("providerFactory is marked non-null but is null");
        }
        if (playerManager == null) {
            throw new NullPointerException("playerManager is marked non-null but is null");
        }
        if (taskProvider == null) {
            throw new NullPointerException("taskProvider is marked non-null but is null");
        }
        if (bridgeModule == null) {
            throw new NullPointerException("bridgeModule is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (rpcHandlerRegistry == null) {
            throw new NullPointerException("rpcHandlerRegistry is marked non-null but is null");
        }
        this.eventManager = eventManager;
        this.bridgeModule = bridgeModule;
        this.configuration = configuration;
        this.playerManager = playerManager;
        this.taskProvider = taskProvider;
        eventManager.registerListener(new PluginIncludeListener("cloudnet-bridge", NodeBridgeManagement.class, moduleHelper, service -> Collections.disjoint(this.configuration.excludedGroups(), service.serviceConfiguration().groups())));
        RPCHandler rpcHandler = providerFactory.newRPCHandlerBuilder(BridgeManagement.class).targetInstance(this).build();
        rpcHandlerRegistry.registerHandler(rpcHandler);
    }

    @PostConstruct
    private void registerListener() {
        this.eventManager.registerListener(NodeBridgeChannelMessageListener.class);
        this.eventManager.registerListener(NodeSetupListener.class);
    }

    @Override
    @NonNull
    public BridgeConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public void configuration(@NonNull BridgeConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.configurationSilently(configuration);
        ChannelMessage.builder().targetAll().channel("bridge_internal_com_channel").message("update_bridge_configuration").buffer(DataBuf.empty().writeObject(configuration)).build().send();
        this.eventManager.callEvent(new BridgeConfigurationUpdateEvent(configuration));
    }

    @Override
    public void registerServices(@NonNull ServiceRegistry registry) {
        if (registry == null) {
            throw new NullPointerException("registry is marked non-null but is null");
        }
        registry.registerProvider(BridgeManagement.class, "NodeBridgeManagement", this);
        registry.registerProvider(PlayerManager.class, "NodePlayerManager", this.playerManager);
    }

    @Override
    public void postInit() {
        for (ServiceTask task : this.taskProvider.serviceTasks()) {
            if (!task.propertyAbsent(BridgeDocProperties.REQUIRED_PERMISSION)) continue;
            ServiceTask newTask = ((ServiceTask.Builder)ServiceTask.builder(task).writeProperty(BridgeDocProperties.REQUIRED_PERMISSION, null)).build();
            this.taskProvider.addServiceTask(newTask);
        }
    }

    public void configurationSilently(@NonNull BridgeConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.configuration = configuration;
        this.bridgeModule.writeConfig(Document.newJsonDocument().appendTree(configuration));
    }
}

