/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.node;

import com.google.common.collect.Iterables;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.DocumentFactory;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import eu.cloudnetservice.driver.module.ModuleLifeCycle;
import eu.cloudnetservice.driver.module.ModuleTask;
import eu.cloudnetservice.driver.module.driver.DriverModule;
import eu.cloudnetservice.driver.network.rpc.defaults.object.DefaultObjectMapper;
import eu.cloudnetservice.driver.registry.ServiceRegistry;
import eu.cloudnetservice.driver.service.ServiceEnvironmentType;
import eu.cloudnetservice.modules.bridge.BridgeManagement;
import eu.cloudnetservice.modules.bridge.config.BridgeConfiguration;
import eu.cloudnetservice.modules.bridge.config.ProxyFallbackConfiguration;
import eu.cloudnetservice.modules.bridge.node.command.BridgeCommand;
import eu.cloudnetservice.modules.bridge.rpc.ComponentObjectSerializer;
import eu.cloudnetservice.modules.bridge.rpc.TitleObjectSerializer;
import eu.cloudnetservice.node.cluster.sync.DataSyncHandler;
import eu.cloudnetservice.node.cluster.sync.DataSyncRegistry;
import eu.cloudnetservice.node.command.CommandProvider;
import eu.cloudnetservice.node.database.LocalDatabase;
import eu.cloudnetservice.node.database.NodeDatabaseProvider;
import eu.cloudnetservice.node.version.ServiceVersionProvider;
import io.leangen.geantyref.TypeFactory;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class CloudNetBridgeModule
extends DriverModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudNetBridgeModule.class);

    @Inject
    public CloudNetBridgeModule(@Named(value="module") @NonNull InjectionLayer<?> layer) {
        if (layer == null) {
            throw new NullPointerException("layer is marked non-null but is null");
        }
        layer.installAutoConfigureBindings(CloudNetBridgeModule.class.getClassLoader(), "bridge");
    }

    @ModuleTask(order=50, lifecycle=ModuleLifeCycle.LOADED)
    public void initNetworkHelpers() {
        DefaultObjectMapper.DEFAULT_MAPPER.registerBinding((Type)((Object)Title.class), new TitleObjectSerializer(), false).registerBinding((Type)((Object)Component.class), new ComponentObjectSerializer(), false);
    }

    @ModuleTask(lifecycle=ModuleLifeCycle.STARTED)
    public void convertOldDatabaseEntries(@NonNull ServiceVersionProvider versionProvider, @NonNull NodeDatabaseProvider databaseProvider) {
        Document document;
        Document lastNetworkPlayerProxyInfo;
        if (versionProvider == null) {
            throw new NullPointerException("versionProvider is marked non-null but is null");
        }
        if (databaseProvider == null) {
            throw new NullPointerException("databaseProvider is marked non-null but is null");
        }
        LocalDatabase playerDb = databaseProvider.database("cloudnet_cloud_players");
        Map first = playerDb.readChunk(0L, 1);
        if (first != null && !first.isEmpty() && (lastNetworkPlayerProxyInfo = (document = (Document)Iterables.getOnlyElement(first.values())).readDocument("lastNetworkPlayerProxyInfo")).empty()) {
            Map chunkData;
            LOGGER.warn("Converting the offline player database, this may take a bit! DO NOT STOP CLOUDNET!");
            int convertedPlayers = 0;
            while ((chunkData = playerDb.readChunk((long)convertedPlayers, 100)) != null) {
                for (Map.Entry entry : chunkData.entrySet()) {
                    Document.Mutable valueCopy = ((Document)entry.getValue()).mutableCopy();
                    Document.Mutable lastProxyInfo = valueCopy.readMutableDocument("lastNetworkConnectionInfo");
                    Document.Mutable networkService = lastProxyInfo.readMutableDocument("networkService");
                    Document.Mutable serviceId = networkService.readMutableDocument("serviceId");
                    String environment = serviceId.getString("environment", "");
                    serviceId.append("environmentName", environment);
                    ServiceEnvironmentType env = versionProvider.environmentType(environment);
                    serviceId.append("environment", env);
                    serviceId.append("nameSplitter", "-");
                    lastProxyInfo.remove("legacy");
                    lastProxyInfo.append("xBoxId", valueCopy.getString("xBoxId"));
                    networkService.append("serviceId", serviceId);
                    lastProxyInfo.append("networkService", networkService);
                    valueCopy.append("lastNetworkPlayerProxyInfo", lastProxyInfo);
                    valueCopy.remove("xBoxId");
                    valueCopy.remove("uniqueId");
                    valueCopy.remove("lastNetworkConnectionInfo");
                    playerDb.insert((String)entry.getKey(), (Document)valueCopy);
                }
                convertedPlayers += chunkData.size();
                if (chunkData.size() == 100) continue;
            }
            LOGGER.info("Successfully converted {} entries", (Object)convertedPlayers);
        }
    }

    @ModuleTask(order=40, lifecycle=ModuleLifeCycle.LOADED)
    public void convertOldConfiguration() {
        Document config = DocumentFactory.json().parse(this.configPath()).readDocument("config");
        if (!config.empty()) {
            HashMap<String, Map<String, String>> messages = new HashMap<String, Map<String, String>>(BridgeConfiguration.DEFAULT_MESSAGES);
            ((Map)messages.get("default")).putAll((Map)config.readObject("messages", TypeFactory.parameterizedClass(Map.class, new Type[]{String.class, String.class})));
            Collection hubCommands = (Collection)config.readObject("hubCommandNames", TypeFactory.parameterizedClass(Collection.class, new Type[]{String.class}));
            Collection excludedGroups = (Collection)config.readObject("excludedGroups", TypeFactory.parameterizedClass(Collection.class, new Type[]{String.class}));
            Collection fallbacks = (Collection)config.readObject("bungeeFallbackConfigurations", TypeFactory.parameterizedClass(Collection.class, new Type[]{ProxyFallbackConfiguration.class}));
            Document.newJsonDocument().appendTree(new BridgeConfiguration(config.getString("prefix"), messages, excludedGroups, hubCommands, fallbacks)).writeTo(this.configPath());
        }
    }

    @ModuleTask(order=127, lifecycle=ModuleLifeCycle.STARTED)
    public void initModule(@NonNull ServiceRegistry serviceRegistry, @NonNull DataSyncRegistry dataSyncRegistry, @Named(value="module") @NonNull InjectionLayer<?> injectionLayer) {
        if (serviceRegistry == null) {
            throw new NullPointerException("serviceRegistry is marked non-null but is null");
        }
        if (dataSyncRegistry == null) {
            throw new NullPointerException("dataSyncRegistry is marked non-null but is null");
        }
        if (injectionLayer == null) {
            throw new NullPointerException("injectionLayer is marked non-null but is null");
        }
        BridgeManagement management = this.readConfigAndInstantiate(injectionLayer, BridgeConfiguration.class, BridgeConfiguration::new, BridgeManagement.class, DocumentFactory.json());
        management.registerServices(serviceRegistry);
        management.postInit();
        dataSyncRegistry.registerHandler(DataSyncHandler.builder().key("bridge-config").nameExtractor($2 -> "Bridge Config").convertObject(BridgeConfiguration.class).writer(management::configuration).singletonCollector(management::configuration).currentGetter($2 -> management.configuration()).build());
    }

    @ModuleTask(lifecycle=ModuleLifeCycle.STARTED)
    public void registerCommand(@NonNull CommandProvider commandProvider) {
        if (commandProvider == null) {
            throw new NullPointerException("commandProvider is marked non-null but is null");
        }
        commandProvider.register(BridgeCommand.class);
    }

    @ModuleTask(lifecycle=ModuleLifeCycle.RELOADING)
    public void handleReload(@Nullable BridgeManagement management) {
        if (management != null) {
            management.configuration(this.loadConfiguration());
        }
    }

    @NonNull
    private BridgeConfiguration loadConfiguration() {
        return this.readConfig(BridgeConfiguration.class, BridgeConfiguration::new, DocumentFactory.json());
    }
}

