/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.config;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.modules.bridge.config.ProxyFallback;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public record ProxyFallbackConfiguration(@NonNull String targetGroup, @Nullable String defaultFallbackTask, @NonNull List<ProxyFallback> fallbacks) {
    @Generated
    public ProxyFallbackConfiguration(@NonNull String targetGroup, @Nullable String defaultFallbackTask, @NonNull List<ProxyFallback> fallbacks) {
        if (targetGroup == null) {
            throw new NullPointerException("targetGroup is marked non-null but is null");
        }
        if (fallbacks == null) {
            throw new NullPointerException("fallbacks is marked non-null but is null");
        }
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull ProxyFallbackConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        return ProxyFallbackConfiguration.builder().targetGroup(configuration.targetGroup()).defaultFallbackTask(configuration.defaultFallbackTask()).fallbacks(configuration.fallbacks());
    }

    public static class Builder {
        private String targetGroup;
        private String defaultFallbackTask;
        private List<ProxyFallback> fallbacks = new ArrayList<ProxyFallback>();

        @NonNull
        public Builder targetGroup(@NonNull String targetGroup) {
            if (targetGroup == null) {
                throw new NullPointerException("targetGroup is marked non-null but is null");
            }
            this.targetGroup = targetGroup;
            return this;
        }

        @NonNull
        public Builder defaultFallbackTask(@Nullable String defaultFallbackTask) {
            this.defaultFallbackTask = defaultFallbackTask;
            return this;
        }

        @NonNull
        public Builder fallbacks(@NonNull List<ProxyFallback> fallbacks) {
            if (fallbacks == null) {
                throw new NullPointerException("fallbacks is marked non-null but is null");
            }
            this.fallbacks = new ArrayList<ProxyFallback>(fallbacks);
            return this;
        }

        @NonNull
        public ProxyFallbackConfiguration build() {
            Preconditions.checkNotNull(this.targetGroup, "Missing targetGroup");
            return new ProxyFallbackConfiguration(this.targetGroup, this.defaultFallbackTask, this.fallbacks);
        }
    }
}

