/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.config;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public record ProxyFallback(int priority, @NonNull String task, @Nullable String permission, @Nullable String forcedHost, @Unmodifiable @NonNull Set<String> availableOnGroups) implements Comparable<ProxyFallback>
{
    @Generated
    public ProxyFallback(int priority, @NonNull String task, @Nullable String permission, @Nullable String forcedHost, @Unmodifiable @NonNull Set<String> availableOnGroups) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (availableOnGroups == null) {
            throw new NullPointerException("availableOnGroups is marked non-null but is null");
        }
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull ProxyFallback fallback) {
        if (fallback == null) {
            throw new NullPointerException("fallback is marked non-null but is null");
        }
        return ProxyFallback.builder().priority(fallback.priority()).task(fallback.task()).permission(fallback.permission()).forcedHost(fallback.forcedHost()).availableOnGroups(fallback.availableOnGroups());
    }

    @Override
    public int compareTo(@NonNull ProxyFallback o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        return Integer.compare(o.priority, this.priority);
    }

    public static class Builder {
        private int priority;
        private String task;
        private String permission;
        private String forcedHost;
        private Set<String> availableOnGroups = new HashSet<String>();

        @NonNull
        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        @NonNull
        public Builder task(@NonNull String task) {
            if (task == null) {
                throw new NullPointerException("task is marked non-null but is null");
            }
            this.task = task;
            return this;
        }

        @NonNull
        public Builder permission(@Nullable String permission) {
            this.permission = permission;
            return this;
        }

        @NonNull
        public Builder forcedHost(@Nullable String forcedHost) {
            this.forcedHost = forcedHost;
            return this;
        }

        @NonNull
        public Builder availableOnGroups(@NonNull Set<String> availableOnGroups) {
            if (availableOnGroups == null) {
                throw new NullPointerException("availableOnGroups is marked non-null but is null");
            }
            this.availableOnGroups = new HashSet<String>(availableOnGroups);
            return this;
        }

        @NonNull
        public ProxyFallback build() {
            Preconditions.checkNotNull(this.task, "Missing task");
            return new ProxyFallback(this.priority, this.task, this.permission, this.forcedHost, Set.copyOf(this.availableOnGroups));
        }
    }
}

