/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.config;

import com.google.common.collect.ImmutableMap;
import eu.cloudnetservice.modules.bridge.config.ProxyFallbackConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public final class BridgeConfiguration {
    public static final Map<String, Map<String, String>> DEFAULT_MESSAGES = ImmutableMap.of("default", new HashMap<String, String>(ImmutableMap.builder().put("command-hub-success-connect", "\u00a77You did successfully connect to %server%.").put("command-hub-already-in-hub", "\u00a7cYou are already connected to a hub service.").put("command-hub-no-server-found", "\u00a77There is currently \u00a7cno \u00a77hub server available.").put("server-join-cancel-because-maintenance", "\u00a77This server is currently in maintenance mode.").put("server-join-cancel-because-permission", "\u00a77You do not have the required permissions to join this server.").put("proxy-join-cancel-because-permission", "\u00a77You do not have the required permissions to join this proxy.").put("proxy-join-cancel-because-maintenance", "\u00a77This proxy is currently in maintenance mode.").put("proxy-join-disconnect-because-no-hub", "\u00a7cThere is currently no hub server you can connect to.").put("command-cloud-sub-command-no-permission", "\u00a77You are not allowed to use \u00a7b%command%.").put("already-connected", "\u00a7cYou are already connected to this network!").put("error-connecting-to-server", "\u00a7cUnable to connect to %server%: %reason%").build()));
    private final String prefix;
    private final Map<String, Map<String, String>> localizedMessages;
    private final Collection<String> excludedGroups;
    private final Collection<String> hubCommandNames;
    private final Collection<ProxyFallbackConfiguration> fallbackConfigurations;

    public BridgeConfiguration() {
        this.prefix = "\u00a77Cloud \u00a78| \u00a7b";
        this.localizedMessages = new HashMap<String, Map<String, String>>(DEFAULT_MESSAGES);
        this.excludedGroups = new ArrayList<String>();
        this.hubCommandNames = Arrays.asList("hub", "lobby", "leave", "l");
        this.fallbackConfigurations = new ArrayList<ProxyFallbackConfiguration>(List.of(ProxyFallbackConfiguration.builder().targetGroup("Proxy").defaultFallbackTask("Lobby").build()));
    }

    public BridgeConfiguration(@NonNull String prefix, @NonNull Map<String, Map<String, String>> localizedMessages, @NonNull Collection<String> excludedGroups, @NonNull Collection<String> hubCommandNames, @NonNull Collection<ProxyFallbackConfiguration> fallbackConfigurations) {
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (localizedMessages == null) {
            throw new NullPointerException("localizedMessages is marked non-null but is null");
        }
        if (excludedGroups == null) {
            throw new NullPointerException("excludedGroups is marked non-null but is null");
        }
        if (hubCommandNames == null) {
            throw new NullPointerException("hubCommandNames is marked non-null but is null");
        }
        if (fallbackConfigurations == null) {
            throw new NullPointerException("fallbackConfigurations is marked non-null but is null");
        }
        this.prefix = prefix;
        this.localizedMessages = localizedMessages;
        this.excludedGroups = excludedGroups;
        this.hubCommandNames = hubCommandNames;
        this.fallbackConfigurations = fallbackConfigurations;
    }

    @NonNull
    public String prefix() {
        return this.prefix;
    }

    @NonNull
    public Collection<ProxyFallbackConfiguration> fallbackConfigurations() {
        return this.fallbackConfigurations;
    }

    @NonNull
    public Collection<String> hubCommandNames() {
        return this.hubCommandNames;
    }

    @NonNull
    public Collection<String> excludedGroups() {
        return this.excludedGroups;
    }

    public void handleMessage(@Nullable Locale locale, @NonNull String key, @NonNull Consumer<String> sender) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.handleMessage(locale, key, Function.identity(), sender, true);
    }

    public <C> void handleMessage(@Nullable Locale locale, @NonNull String key, @NonNull Function<String, C> toComponentConverter, @NonNull Consumer<C> sender) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (toComponentConverter == null) {
            throw new NullPointerException("toComponentConverter is marked non-null but is null");
        }
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.handleMessage(locale, key, toComponentConverter, sender, true);
    }

    public <C> void handleMessage(@Nullable Locale locale, @NonNull String key, @NonNull Function<String, C> toComponentConverter, @NonNull Consumer<C> sender, boolean withPrefix) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (toComponentConverter == null) {
            throw new NullPointerException("toComponentConverter is marked non-null but is null");
        }
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        Object component = this.findMessage(locale, key, toComponentConverter, null, withPrefix);
        if (component != null) {
            sender.accept(component);
        }
    }

    public <C> @UnknownNullability C findMessage(@Nullable Locale locale, @NonNull String key, @NonNull Function<String, C> toComponentConverter, @Nullable C defaultValue, boolean withPrefix) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (toComponentConverter == null) {
            throw new NullPointerException("toComponentConverter is marked non-null but is null");
        }
        String message = null;
        if (locale != null && (message = this.resolveMessage(this.localizedMessages.get(locale.toString()), key)) == null) {
            message = this.resolveMessage(this.localizedMessages.get(locale.getLanguage()), key);
        }
        if (message == null && (message = this.resolveMessage(this.localizedMessages.get("default"), key)) == null) {
            return defaultValue;
        }
        String formattedMessage = String.format("%s%s", withPrefix ? this.prefix : "", message);
        C component = toComponentConverter.apply(formattedMessage);
        return component != null ? component : defaultValue;
    }

    @Nullable
    private String resolveMessage(@Nullable Map<String, String> messages, @NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return messages == null ? null : messages.get(key);
    }

    @Generated
    public String toString() {
        return "BridgeConfiguration(prefix=" + this.prefix + ", localizedMessages=" + String.valueOf(this.localizedMessages) + ", excludedGroups=" + String.valueOf(this.excludedGroups) + ", hubCommandNames=" + String.valueOf(this.hubCommandNames) + ", fallbackConfigurations=" + String.valueOf(this.fallbackConfigurations) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BridgeConfiguration)) {
            return false;
        }
        BridgeConfiguration other = (BridgeConfiguration)o;
        String this$prefix = this.prefix;
        String other$prefix = other.prefix;
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        Map<String, Map<String, String>> this$localizedMessages = this.localizedMessages;
        Map<String, Map<String, String>> other$localizedMessages = other.localizedMessages;
        if (this$localizedMessages == null ? other$localizedMessages != null : !((Object)this$localizedMessages).equals(other$localizedMessages)) {
            return false;
        }
        Collection<String> this$excludedGroups = this.excludedGroups;
        Collection<String> other$excludedGroups = other.excludedGroups;
        if (this$excludedGroups == null ? other$excludedGroups != null : !((Object)this$excludedGroups).equals(other$excludedGroups)) {
            return false;
        }
        Collection<String> this$hubCommandNames = this.hubCommandNames;
        Collection<String> other$hubCommandNames = other.hubCommandNames;
        if (this$hubCommandNames == null ? other$hubCommandNames != null : !((Object)this$hubCommandNames).equals(other$hubCommandNames)) {
            return false;
        }
        Collection<ProxyFallbackConfiguration> this$fallbackConfigurations = this.fallbackConfigurations;
        Collection<ProxyFallbackConfiguration> other$fallbackConfigurations = other.fallbackConfigurations;
        return !(this$fallbackConfigurations == null ? other$fallbackConfigurations != null : !((Object)this$fallbackConfigurations).equals(other$fallbackConfigurations));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $prefix = this.prefix;
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        Map<String, Map<String, String>> $localizedMessages = this.localizedMessages;
        result = result * 59 + ($localizedMessages == null ? 43 : ((Object)$localizedMessages).hashCode());
        Collection<String> $excludedGroups = this.excludedGroups;
        result = result * 59 + ($excludedGroups == null ? 43 : ((Object)$excludedGroups).hashCode());
        Collection<String> $hubCommandNames = this.hubCommandNames;
        result = result * 59 + ($hubCommandNames == null ? 43 : ((Object)$hubCommandNames).hashCode());
        Collection<ProxyFallbackConfiguration> $fallbackConfigurations = this.fallbackConfigurations;
        result = result * 59 + ($fallbackConfigurations == null ? 43 : ((Object)$fallbackConfigurations).hashCode());
        return result;
    }
}

