/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge;

import eu.cloudnetservice.common.resource.ResourceFormatter;
import eu.cloudnetservice.common.util.StringUtil;
import eu.cloudnetservice.driver.provider.CloudServiceFactory;
import eu.cloudnetservice.driver.provider.ServiceTaskProvider;
import eu.cloudnetservice.driver.service.ServiceConfiguration;
import eu.cloudnetservice.driver.service.ServiceCreateResult;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import eu.cloudnetservice.driver.service.ServiceLifeCycle;
import eu.cloudnetservice.modules.bridge.BridgeDocProperties;
import eu.cloudnetservice.wrapper.configuration.WrapperConfiguration;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public final class BridgeServiceHelper {
    private final AtomicInteger maxPlayers = new AtomicInteger();
    private final AtomicReference<String> motd = new AtomicReference<String>("");
    private final AtomicReference<String> extra = new AtomicReference<String>("");
    private final AtomicReference<String> state = new AtomicReference<String>("LOBBY");
    private final ServiceTaskProvider taskProvider;
    private final CloudServiceFactory serviceFactory;
    private final WrapperConfiguration wrapperConfiguration;

    @Inject
    public BridgeServiceHelper(@NonNull ServiceTaskProvider taskProvider, @NonNull CloudServiceFactory serviceFactory, @NonNull WrapperConfiguration wrapperConfiguration) {
        if (taskProvider == null) {
            throw new NullPointerException("taskProvider is marked non-null but is null");
        }
        if (serviceFactory == null) {
            throw new NullPointerException("serviceFactory is marked non-null but is null");
        }
        if (wrapperConfiguration == null) {
            throw new NullPointerException("wrapperConfiguration is marked non-null but is null");
        }
        this.taskProvider = taskProvider;
        this.serviceFactory = serviceFactory;
        this.wrapperConfiguration = wrapperConfiguration;
    }

    @NonNull
    public static ServiceInfoState guessStateFromServiceInfoSnapshot(@NonNull ServiceInfoSnapshot service) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        if (service.lifeCycle() != ServiceLifeCycle.RUNNING || BridgeServiceHelper.inGameService(service)) {
            return ServiceInfoState.STOPPED;
        }
        if (BridgeServiceHelper.emptyService(service)) {
            return ServiceInfoState.EMPTY_ONLINE;
        }
        if (BridgeServiceHelper.fullService(service)) {
            return ServiceInfoState.FULL_ONLINE;
        }
        if (BridgeServiceHelper.startingService(service)) {
            return ServiceInfoState.STARTING;
        }
        if (service.connected()) {
            return ServiceInfoState.ONLINE;
        }
        return ServiceInfoState.STOPPED;
    }

    @NonNull
    public static String fillCommonPlaceholders(@NonNull String value, @Nullable String group, @Nullable ServiceInfoSnapshot service) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        value = value.replace("%group%", group == null ? "" : group);
        if (service == null) {
            return value;
        }
        value = value.replace("%name%", service.serviceId().name());
        value = value.replace("%task%", service.serviceId().taskName());
        value = value.replace("%node%", service.serviceId().nodeUniqueId());
        value = value.replace("%unique_id%", service.serviceId().uniqueId().toString());
        value = value.replace("%environment%", service.serviceId().environment().name());
        value = value.replace("%task_id%", Integer.toString(service.serviceId().taskServiceId()));
        value = value.replace("%uid%", service.serviceId().uniqueId().toString().split("-")[0]);
        value = value.replace("%life_cycle%", service.lifeCycle().name());
        value = value.replace("%runtime%", service.configuration().runtime());
        value = value.replace("%port%", Integer.toString(service.configuration().port()));
        value = value.replace("%pid%", Long.toString(service.processSnapshot().pid()));
        value = value.replace("%threads%", Integer.toString(service.processSnapshot().threads().size()));
        value = value.replace("%heap_usage%", Long.toString(service.processSnapshot().heapUsageMemory()));
        value = value.replace("%max_heap_usage%", Long.toString(service.processSnapshot().maxHeapMemory()));
        value = value.replace("%cpu_usage%", ResourceFormatter.formatTwoDigitPrecision(service.processSnapshot().cpuUsage()));
        Boolean online = service.readProperty(BridgeDocProperties.IS_ONLINE);
        value = value.replace("%online%", online != false ? "Online" : "Offline");
        if (online.booleanValue()) {
            value = value.replace("%online_players%", Integer.toString(service.readProperty(BridgeDocProperties.ONLINE_COUNT)));
            value = value.replace("%max_players%", Integer.toString(service.readProperty(BridgeDocProperties.MAX_PLAYERS)));
            value = value.replace("%motd%", service.readProperty(BridgeDocProperties.MOTD));
            value = value.replace("%extra%", service.readProperty(BridgeDocProperties.EXTRA));
            value = value.replace("%state%", service.readProperty(BridgeDocProperties.STATE));
            value = value.replace("%version%", service.readProperty(BridgeDocProperties.VERSION));
        }
        return value;
    }

    public static boolean emptyService(@NonNull ServiceInfoSnapshot service) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        return service.connected() && service.readProperty(BridgeDocProperties.IS_ONLINE) != false && service.readProperty(BridgeDocProperties.ONLINE_COUNT) == 0;
    }

    public static boolean fullService(@NonNull ServiceInfoSnapshot service) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        return service.connected() && service.readProperty(BridgeDocProperties.IS_ONLINE) != false && service.readProperty(BridgeDocProperties.ONLINE_COUNT) >= service.readProperty(BridgeDocProperties.MAX_PLAYERS);
    }

    public static boolean startingService(@NonNull ServiceInfoSnapshot service) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        return service.lifeCycle() == ServiceLifeCycle.RUNNING && service.readProperty(BridgeDocProperties.IS_ONLINE) == false;
    }

    public static boolean inGameService(@NonNull ServiceInfoSnapshot service) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        return service.lifeCycle() == ServiceLifeCycle.RUNNING && service.connected() && service.readProperty(BridgeDocProperties.IS_ONLINE) != false && (BridgeServiceHelper.matchesInGameString(service.readProperty(BridgeDocProperties.MOTD)) || BridgeServiceHelper.matchesInGameString(service.readProperty(BridgeDocProperties.EXTRA)) || BridgeServiceHelper.matchesInGameString(service.readProperty(BridgeDocProperties.STATE)));
    }

    private static boolean matchesInGameString(@Nullable String value) {
        if (value == null) {
            return false;
        }
        String loweredValue = StringUtil.toLower(value);
        return loweredValue.contains("ingame") || loweredValue.contains("running") || loweredValue.contains("playing");
    }

    public void changeToIngame() {
        this.changeToIngame(true);
    }

    @NonNull
    public AtomicInteger maxPlayers() {
        return this.maxPlayers;
    }

    @NonNull
    public AtomicReference<String> motd() {
        return this.motd;
    }

    @NonNull
    public AtomicReference<String> extra() {
        return this.extra;
    }

    @NonNull
    public AtomicReference<String> state() {
        return this.state;
    }

    public void changeToIngame(boolean autoStartService) {
        if (!this.state.getAndSet("INGAME").equalsIgnoreCase("ingame") && autoStartService) {
            String taskName = this.wrapperConfiguration.serviceConfiguration().serviceId().taskName();
            ((CompletableFuture)((CompletableFuture)this.taskProvider.serviceTaskAsync(taskName).thenApply(task -> ServiceConfiguration.builder(task).build())).thenApply(this.serviceFactory::createCloudService)).thenAccept(createResult -> {
                if (createResult.state() == ServiceCreateResult.State.CREATED) {
                    createResult.serviceInfo().provider().start();
                }
            });
        }
    }

    public static enum ServiceInfoState {
        STOPPED,
        STARTING,
        EMPTY_ONLINE,
        FULL_ONLINE,
        ONLINE;

    }
}

