/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.ext.updater.util;

import java.net.URI;
import lombok.NonNull;

public final class GitHubUtil {
    private static final String GITHUB_URL_FORMAT = "https://github.com/%s/raw/%s/%s";

    private GitHubUtil() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static URI buildUri(@NonNull String repo, @NonNull String branch, @NonNull String filePath) {
        if (repo == null) {
            throw new NullPointerException("repo is marked non-null but is null");
        }
        if (branch == null) {
            throw new NullPointerException("branch is marked non-null but is null");
        }
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        return URI.create(String.format(GITHUB_URL_FORMAT, repo, branch, filePath));
    }
}

