/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.ext.updater.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import lombok.NonNull;

public final class ChecksumUtil {
    private static final ThreadLocal<byte[]> READ_BUFFERS = ThreadLocal.withInitial(() -> new byte[8096]);

    private ChecksumUtil() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static String fileShaSum(@NonNull Path path) {
        String string;
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        byte[] readBuffer = READ_BUFFERS.get();
        DigestInputStream stream = new DigestInputStream(Files.newInputStream(path, new OpenOption[0]), ChecksumUtil.newSha3256Digest());
        try {
            while (stream.read(readBuffer) != -1) {
            }
            string = ChecksumUtil.bytesToHex(stream.getMessageDigest().digest());
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                throw new IllegalStateException("Unable to get sha3_256 digest of file " + String.valueOf(path), exception);
            }
        }
        stream.close();
        return string;
    }

    @NonNull
    private static MessageDigest newSha3256Digest() {
        try {
            return MessageDigest.getInstance("SHA3-256");
        }
        catch (NoSuchAlgorithmException exception) {
            throw new IllegalStateException("Unable to retrieve message digest for algorithm sha3-256", exception);
        }
    }

    @NonNull
    private static String bytesToHex(byte[] input) {
        StringBuilder buffer = new StringBuilder();
        for (byte b : input) {
            buffer.append(Character.forDigit(b >> 4 & 0xF, 16));
            buffer.append(Character.forDigit(b & 0xF, 16));
        }
        return buffer.toString();
    }
}

