/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.ext.updater.defaults;

import eu.cloudnetservice.ext.updater.Updater;
import eu.cloudnetservice.ext.updater.UpdaterRegistry;
import java.util.Deque;
import java.util.LinkedList;
import lombok.NonNull;

public abstract class DefaultUpdaterRegistry<T, C>
implements UpdaterRegistry<T, C> {
    protected final Deque<Updater<T>> updaters = new LinkedList<Updater<T>>();

    @Override
    public void runUpdater(@NonNull C context, boolean onlyRequiredUpdates) throws Exception {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        T updaterContext = this.provideContext(context);
        for (Updater<T> updater : this.updaters) {
            updater.executeUpdates(updaterContext, onlyRequiredUpdates);
        }
    }

    @Override
    public void registerUpdater(@NonNull Updater<T> updater) {
        if (updater == null) {
            throw new NullPointerException("updater is marked non-null but is null");
        }
        this.updaters.addLast(updater);
    }

    @NonNull
    protected abstract T provideContext(@NonNull C var1) throws Exception;
}

