/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.ext.platforminject.api.util;

import java.util.function.Function;
import java.util.function.Supplier;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public final class FunctionalUtil {
    private static final Function<?, Object> IDENTITY = Function.identity();

    private FunctionalUtil() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static <I> Function<I, Object> identity() {
        return IDENTITY;
    }

    @NonNull
    public static <T> Supplier<T> memoizing(@NonNull Supplier<T> delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        return new MemoizingSupplier<T>(delegate);
    }

    private static final class MemoizingSupplier<T>
    implements Supplier<T> {
        private Supplier<T> delegate;
        private T value;
        private volatile boolean initialized;

        private MemoizingSupplier(@NonNull Supplier<T> delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T get() {
            if (!this.initialized) {
                MemoizingSupplier memoizingSupplier = this;
                synchronized (memoizingSupplier) {
                    if (!this.initialized) {
                        this.initialized = true;
                        this.value = this.delegate.get();
                        this.delegate = null;
                        return this.value;
                    }
                }
            }
            return this.value;
        }
    }
}

