/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.ext.platforminject.api.defaults;

import dev.derklaro.aerogel.Injector;
import dev.derklaro.aerogel.SpecifiedInjector;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import eu.cloudnetservice.ext.platforminject.api.PlatformEntrypoint;
import eu.cloudnetservice.ext.platforminject.api.PlatformPluginInfo;
import eu.cloudnetservice.ext.platforminject.api.PlatformPluginManager;
import eu.cloudnetservice.ext.platforminject.api.defaults.DefaultPlatformPluginInfo;
import eu.cloudnetservice.ext.platforminject.api.inject.BindingsInstaller;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasePlatformPluginManager<I, T>
implements PlatformPluginManager<I, T> {
    protected static final InjectionLayer<Injector> BASE_INJECTION_LAYER = InjectionLayer.ext();
    protected static final StackWalker RETAINING_STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private final Function<T, I> idExtractor;
    private final Function<T, Object> mainClassExtractor;
    private final Map<I, PlatformPluginInfo<I, T, ?>> constructedPlugins = new ConcurrentHashMap(16, 0.9f, 1);

    protected BasePlatformPluginManager(@NonNull Function<T, I> idExtractor, @NonNull Function<T, Object> mainClassExtractor) {
        if (idExtractor == null) {
            throw new NullPointerException("idExtractor is marked non-null but is null");
        }
        if (mainClassExtractor == null) {
            throw new NullPointerException("mainClassExtractor is marked non-null but is null");
        }
        this.idExtractor = idExtractor;
        this.mainClassExtractor = mainClassExtractor;
    }

    @Override
    @NonNull
    public Collection<PlatformPluginInfo<I, T, ?>> loadedPlugins() {
        return this.constructedPlugins.values();
    }

    @Override
    @Nullable
    public PlatformPluginInfo<I, T, ?> loadedPlugin(@NonNull T platformData) {
        if (platformData == null) {
            throw new NullPointerException("platformData is marked non-null but is null");
        }
        I id = this.idExtractor.apply(platformData);
        return id == null ? null : this.loadedPluginById(id);
    }

    @Override
    @Nullable
    public PlatformPluginInfo<I, T, ?> loadedPluginById(@NonNull I id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.constructedPlugins.get(id);
    }

    @Override
    public void constructAndLoad(@NonNull Class<? extends PlatformEntrypoint> pluginClass, @NonNull T platformData) {
        if (pluginClass == null) {
            throw new NullPointerException("pluginClass is marked non-null but is null");
        }
        if (platformData == null) {
            throw new NullPointerException("platformData is marked non-null but is null");
        }
        I pluginId = this.idExtractor.apply(platformData);
        if (pluginId == null || this.constructedPlugins.containsKey(pluginId)) {
            return;
        }
        InjectionLayer<SpecifiedInjector> pluginLayer = this.createInjectionLayer(platformData);
        Class callerClass = RETAINING_STACK_WALKER.walk(stream -> stream.skip(2L).map(StackWalker.StackFrame::getDeclaringClass).findFirst().orElseThrow(() -> new IllegalStateException("Unable to resolve calling platform main class")));
        this.configureInjectionLayer(pluginLayer, callerClass);
        Object platformMainInstance = this.mainClassExtractor.apply(platformData);
        pluginLayer.register(platformMainInstance, platformMainInstance.getClass().getClassLoader());
        PlatformEntrypoint pluginInstance = pluginLayer.instance(pluginClass);
        DefaultPlatformPluginInfo<I, T, PlatformEntrypoint> pluginInfo = new DefaultPlatformPluginInfo<I, T, PlatformEntrypoint>(pluginId, platformData, pluginLayer, pluginInstance, pluginClass);
        PlatformPluginInfo presentInstance = this.constructedPlugins.putIfAbsent(pluginId, pluginInfo);
        if (presentInstance == null) {
            pluginInstance.onLoad();
        }
    }

    @Override
    public void disablePlugin(@NonNull T platformData) {
        if (platformData == null) {
            throw new NullPointerException("platformData is marked non-null but is null");
        }
        I pluginId = this.idExtractor.apply(platformData);
        if (pluginId != null) {
            this.disablePluginById(pluginId);
        }
    }

    @Override
    public void disablePluginById(@NonNull I id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        PlatformPluginInfo<I, T, ?> pluginInfo = this.constructedPlugins.remove(id);
        if (pluginInfo != null) {
            pluginInfo.close();
        }
    }

    protected void configureInjectionLayer(@NonNull InjectionLayer<?> layer, @NonNull Class<?> platformMainClass) {
        if (layer == null) {
            throw new NullPointerException("layer is marked non-null but is null");
        }
        if (platformMainClass == null) {
            throw new NullPointerException("platformMainClass is marked non-null but is null");
        }
        try {
            String bindingsClassName = platformMainClass.getName().replaceFirst("(?s)(.*)Entrypoint", "$1Bindings");
            Class<?> bindingsClass = Class.forName(bindingsClassName, false, platformMainClass.getClassLoader());
            Constructor<?> constructor = bindingsClass.getConstructor(new Class[0]);
            Object installerInstance = constructor.newInstance(new Object[0]);
            if (installerInstance instanceof BindingsInstaller) {
                BindingsInstaller installer = (BindingsInstaller)installerInstance;
                installer.applyBindings(layer);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NonNull
    protected abstract InjectionLayer<SpecifiedInjector> createInjectionLayer(@NonNull T var1);
}

