/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.ext.component;

import eu.cloudnetservice.ext.component.ComponentConverter;
import lombok.NonNull;

final class MappingConverter<C>
extends ComponentConverter<C> {
    private final ComponentConverter<?> original;
    private final ComponentConverter<C> downstream;

    MappingConverter(@NonNull ComponentConverter<?> original, @NonNull ComponentConverter<C> downstream) {
        super(downstream.source, downstream.target);
        if (original == null) {
            throw new NullPointerException("original is marked non-null but is null");
        }
        if (downstream == null) {
            throw new NullPointerException("downstream is marked non-null but is null");
        }
        this.original = original;
        this.downstream = downstream;
    }

    @Override
    @NonNull
    public String convertText(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        String convertedInput = this.original.convertText(input);
        return this.downstream.convertText(convertedInput);
    }

    @Override
    @NonNull
    public C convert(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        String convertedInput = this.original.convertText(input);
        return this.downstream.convert(convertedInput);
    }
}

