/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.ext.component;

import eu.cloudnetservice.ext.component.ComponentFormat;
import eu.cloudnetservice.ext.component.MappingConverter;
import lombok.NonNull;

public class ComponentConverter<C> {
    final ComponentFormat<?> source;
    final ComponentFormat<C> target;

    ComponentConverter(@NonNull ComponentFormat<?> source, @NonNull ComponentFormat<C> target) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.source = source;
        this.target = target;
    }

    @NonNull
    public C convert(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        String convertedText = this.convertText(input);
        return this.target.encodeStringToComponent(convertedText);
    }

    @NonNull
    public String convertText(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        StringBuilder result = new StringBuilder();
        char[] chars = input.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (i < chars.length - 1) {
                char curr = chars[i];
                char next = chars[i + 1];
                if (this.source.nextSegmentIsLegacyFormatting(chars, i, curr, next)) {
                    result.append(this.target.colorIndicationChar()).append(next);
                    ++i;
                    continue;
                }
                if (this.source.nextSegmentIsHexadecimalFormatting(chars, i, curr, next)) {
                    boolean sourceHexDel = this.source.usesColorCharAsHexDelimiter();
                    boolean targetHexDel = this.target.usesColorCharAsHexDelimiter();
                    result.append(this.target.colorIndicationChar()).append(this.target.hexIndicationChar());
                    for (int pos = i + 2; pos < i + this.source.hexSegmentLength(); ++pos) {
                        char c = chars[pos];
                        if (sourceHexDel && this.source.charIsValidColorIndicationChar(chars, pos, c)) continue;
                        if (targetHexDel) {
                            result.append(this.target.colorIndicationChar());
                        }
                        result.append(c);
                    }
                    i += this.source.hexSegmentLength() - 1;
                    continue;
                }
            }
            result.append(chars[i]);
        }
        return result.toString();
    }

    @NonNull
    public <T> ComponentConverter<T> andThen(@NonNull ComponentConverter<T> downstream) {
        if (downstream == null) {
            throw new NullPointerException("downstream is marked non-null but is null");
        }
        return new MappingConverter<T>(this, downstream);
    }
}

