/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.ext.component;

import eu.cloudnetservice.ext.component.JavaEditionComponentFormat;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

final class AdventureComponentFormat
extends JavaEditionComponentFormat<Component> {
    private static final char HEX_CHAR = '#';
    private static final int HEX_SEG_LENGTH = 8;
    private static final LegacyComponentSerializer SERIALIZER = LegacyComponentSerializer.builder().character('\u00a7').extractUrls().hexColors().build();

    AdventureComponentFormat() {
    }

    @Override
    public int hexSegmentLength() {
        return 8;
    }

    @Override
    public char hexIndicationChar() {
        return '#';
    }

    @Override
    public boolean usesColorCharAsHexDelimiter() {
        return false;
    }

    @Override
    public boolean nextSegmentIsHexadecimalFormatting(char[] fullData, int pos, char current, char next) {
        return (current == '\u00a7' || current == '&') && next == '#' && pos + 8 < fullData.length;
    }

    @Override
    @NonNull
    public Component encodeStringToComponent(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return SERIALIZER.deserialize(text);
    }
}

