/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.ext.adventure;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import lombok.NonNull;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.format.TextFormat;
import org.jetbrains.annotations.Nullable;

public final class AdventureTextFormatLookup {
    private static final String ALL_CHARS;
    private static final List<TextFormat> FORMATS;

    private AdventureTextFormatLookup() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public static TextFormat findFormat(char formatChar) {
        int formatIndex = ALL_CHARS.indexOf(formatChar);
        return formatIndex == -1 ? null : FORMATS.get(formatIndex);
    }

    @Nullable
    public static NamedTextColor findColor(char colorChar) {
        NamedTextColor color;
        TextFormat format = AdventureTextFormatLookup.findFormat(colorChar);
        return format instanceof NamedTextColor ? (color = (NamedTextColor)format) : null;
    }

    @Nullable
    public static TextDecoration findDecoration(char decorationChar) {
        TextDecoration decoration;
        TextFormat format = AdventureTextFormatLookup.findFormat(decorationChar);
        return format instanceof TextDecoration ? (decoration = (TextDecoration)format) : null;
    }

    @Nullable
    public static Character findFormatChar(@NonNull TextFormat format) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        int formatIndex = FORMATS.indexOf(format);
        return formatIndex == -1 ? null : Character.valueOf(ALL_CHARS.charAt(formatIndex));
    }

    static {
        LinkedHashMap<StyleBuilderApplicable, String> formats = new LinkedHashMap<StyleBuilderApplicable, String>(21);
        formats.put(NamedTextColor.BLACK, "0");
        formats.put(NamedTextColor.DARK_BLUE, "1");
        formats.put(NamedTextColor.DARK_GREEN, "2");
        formats.put(NamedTextColor.DARK_AQUA, "3");
        formats.put(NamedTextColor.DARK_RED, "4");
        formats.put(NamedTextColor.DARK_PURPLE, "5");
        formats.put(NamedTextColor.GOLD, "6");
        formats.put(NamedTextColor.GRAY, "7");
        formats.put(NamedTextColor.DARK_GRAY, "8");
        formats.put(NamedTextColor.BLUE, "9");
        formats.put(NamedTextColor.GREEN, "a");
        formats.put(NamedTextColor.AQUA, "b");
        formats.put(NamedTextColor.RED, "c");
        formats.put(NamedTextColor.LIGHT_PURPLE, "d");
        formats.put(NamedTextColor.YELLOW, "e");
        formats.put(NamedTextColor.WHITE, "f");
        formats.put(TextDecoration.OBFUSCATED, "k");
        formats.put(TextDecoration.BOLD, "l");
        formats.put(TextDecoration.STRIKETHROUGH, "m");
        formats.put(TextDecoration.UNDERLINED, "n");
        formats.put(TextDecoration.ITALIC, "o");
        FORMATS = new LinkedList(formats.keySet());
        ALL_CHARS = String.join((CharSequence)"", formats.values());
    }
}

